% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bIndicator.R
\name{bIndicator}
\alias{bIndicator}
\title{Binary Indicator for Binomial RDT}
\usage{
bIndicator(pi, R)
}
\arguments{
\item{pi}{Failure probability.}

\item{R}{Lower Level reliability requirement.}
}
\value{
0 -- No; 1 -- Yes.
}
\description{
Define the binary indicator function to check whether the failure probability satisfies the lower level reliability requirement (for binomial RDT).
}
\examples{
bIndicator(pi = 0.05, R = 0.9)
bIndicator(pi = 0.2, R = 0.9)
}
\seealso{
\code{\link{bcore}} for getting the core probability of passting the test;
\code{\link{boptimal_n}} for getting the optimal test sample size;
\code{\link{bconsumerrisk}} for getting the consumer's risk;
}
