% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brainCells.R
\name{brainCells}
\alias{brainCells}
\title{Estimate brain cell type proportions in bulk expression data with marker genes.}
\usage{
brainCells(
  inputMat,
  nMarker = 50,
  species = "combined",
  data_set = "mckenzie",
  celltypes = c("ast", "end", "mic", "neu", "oli", "opc"),
  method = "SVD",
  scale = TRUE
)
}
\arguments{
\item{inputMat}{Gene expression data frame or matrix, with rownames corresponding to gene names, some of which are marker genes, and columns corresponding to samples.}

\item{nMarker}{The number of marker genes (that are present in your expression data set) to use in estimating the surrogate cell type proportion variable for each cell type.}

\item{species}{By default, this function uses markers from combined human and mouse measurements, which are the most robust and reliable, as the gene expression patterns are very conserved between these two species. Other options are "human" and "mouse" for data specific to those species. Note that OPCs only have 500 gene symbols in this case, and are taken from only the Darmanis et al or Tasic et al data sets, respectively.}

\item{data_set}{Which data set the data should be derived from. Options are "mckenzie" (default), "kelley". Note that the "kelley" data set will ignore the "species" argument.}

\item{celltypes}{Character vector of which cell types to estimate.}

\item{method}{To estimate the cell type proportions, can either use "PCA" or "SVD".}

\item{scale}{Whether or not to scale the gene expression data from each marker gene prior to using it as an input for dimension reduction.}
}
\value{
A sample-by-cell type matrix of estimate cell type proportion variables.
}
\description{
This function uses marker genes estimated in a meta-analysis of brain cell type-associated RNA expression data sets, and uses them as input for the findCells cell type proportion estimation procedure pipeline.
}
\examples{
\donttest{
ct_res = brainCells(aba_marker_expression, nMarker = 50, species = "combined")
cor.test(ct_res[, "mic"], as.numeric(aba_pheno_data$ihc_iba1_ffpe), method = "spearman")
}
}
