% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Bypass}
\alias{Bypass}
\title{Median charges for coronary bypass at 17 hospitals in North Carolina}
\format{
A data frame/tibble with 17 observations on two variables
\describe{ 
\item{hospital}{a factor with levels \code{Carolinas Med
Ct}, \code{Duke Med Ct}, \code{Durham Regional}, \code{Forsyth Memorial},
\code{Frye Regional}, \code{High Point Regional}, \code{Memorial Mission},
\code{Mercy}, \code{Moore Regional}, \code{Moses Cone Memorial}, \code{NC
Baptist}, \code{New Hanover Regional}, \code{Pitt Co. Memorial},
\code{Presbyterian}, \code{Rex}, \code{Univ of North Carolina}, and \code{Wake
County}}
\item{charge}{median charge for coronary bypass} 
}
}
\source{
\emph{Consumer's Guide to Hospitalization Charges in North Carolina Hospitals}
(August 1994), North Carolina Medical Database Commission, Department of Insurance.
}
\usage{
Bypass
}
\description{
Data for Exercises 5.104 and 6.43
}
\examples{

EDA(Bypass$charge)
t.test(Bypass$charge, conf.level=.90)$conf
t.test(Bypass$charge, mu = 35000)

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
