% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/btsr_generic.R
\name{predict.btsr}
\alias{predict.btsr}
\title{Predict method for BTSR}
\usage{
\method{predict}{btsr}(object, newdata, nnew = 0, debug = FALSE, ...)
}
\arguments{
\item{object}{Object of class inheriting from \code{"btsr"}}

\item{newdata}{A matrix with new values for the regressors. If omitted and
\code{"xreg"} is present in the model, the fitted values are returned. If the
model does not include regressors, the functions will use the value of
\code{nnew}.}

\item{nnew}{number of out-of-sample forecasts required. If \code{newdata} is
provided, \code{nnew} is ignored.}

\item{debug}{logical, if \code{TRUE} the output from Fortran is return (for
debugging purposes). Default is \code{debug = FALSE}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
If \code{nnew = 0}, returns a list with in-sample predictions (\code{fitted.values},
\code{etat} and \code{error}), otherwise, returns a list with the following arguments

\itemize{
\item \code{fitted.values}: in-sample forecast.\cr
If \eqn{\nu_t} is fixed: a vector with the in-sample value of \eqn{\mu_t}.\cr
If \eqn{\nu_t} is time varying: a matrix with the in-sample values of
\eqn{\mu_t}, \eqn{\nu_t} and \eqn{\vartheta_t}.

\item \code{etat}: the linear predictor(s)\cr For models with \eqn{\nu} fixed,
returns \eqn{\eta_{1t} = g_{11}(\mu_t)}\cr For models with time varying
\eqn{\nu}, returns a matrix whose columns are \eqn{\eta_{1t} = g_{11}(\mu_t)}
and \eqn{\eta_{2t} = g_{21}(\vartheta_t)}.

\item \code{error}: the error term \eqn{e_{1t}} (depends on the argument
\code{error.scale})

\item \code{residual}: The (in-sample) residuals, that is, the observed values
\eqn{Y_t} minus the fitted values \eqn{\mu_t}. The same as the \code{error} term
if \code{error.scale = 0}.

\item \code{forecast}: the out-of-sample forecast.\cr
If \eqn{\nu_t} is fixed: a vector with the predicted values for \eqn{\mu_t}
and \eqn{\eta_{1t}}\cr
If \eqn{\nu_t} is time varying: a matrix the predicted values for \eqn{\mu_t}
and \eqn{\eta_{1t}}, \eqn{\nu_t}, \eqn{\vartheta_t} and \eqn{\eta_{2t}}.\cr
For BARC models also returs a column with predicted values for the iterated
map.

\item \code{TS}: only for \code{"BARC"} models. The iterated map.

\item \code{xnew}: out-of-sample values for \code{xreg} (if presented). These are the
values passed through \code{newdata}.
}
}
\description{
Predicted values based on btsr object.
}
\details{
\code{predict.btsr} produces predicted values, obtained by evaluating the
regression function in the frame \code{newdata}.

If \code{newdata} is omitted the predictions are based on the data used for the
fit.

For now, prediction intervals are not provided.
}
\examples{
#------------------------------------------------------------
# Generating a Beta model were mut does not vary with time
# yt ~ Beta(a,b), a = mu*nu, b = (1-mu)*nu
#------------------------------------------------------------

y <- btsr.sim(
  model = "BARFIMA", linkg = "linear",
  n = 100, coefs = list(alpha = 0.2, nu = 20)
)

# fitting the model
f <- btsr.fit(
  model = "BARFIMA", yt = y, report = TRUE,
  start = list(alpha = 0.5, nu = 10),
  linkg = "linear", d = FALSE
)

pred <- predict(f, nnew = 5)
pred$forecast

}
