% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbsik.R
\name{bbsik}
\alias{bbsik}
\title{Bp Barcoding Species Identify using Kmer}
\usage{
bbsik(ref, que, kmer = kmer, UseBuiltModel = FALSE, lr = 5e-05, maxit = 1e+06)
}
\arguments{
\item{ref}{object of class "DNAbin" used as a reference dataset, which contains taxon information.}

\item{que}{object of class "DNAbin", which needs to be inferred.}

\item{kmer}{a numeric indicating the length of kmer used.}

\item{UseBuiltModel}{logic value to indicate whether a built model is used 
or not.}

\item{lr}{parameter for weight decay. Default 5e-5.}

\item{maxit}{maximum number of iterations. Default 1e+6.}
}
\value{
a list containing model parameters used, species identification success rates using references,
query sequences, species inferred, and corresponding confidence levels (bp probability for BP-based method).
}
\description{
Species identification using BP-based method for both protein-coding
barcodes, for instance, COI, and non-coding barcodes, such as, ITS, using kmer statistics.
}
\examples{
data(TibetanMoth) 
ref<-as.DNAbin(as.character(TibetanMoth[1:50,]))
que<-as.DNAbin(as.character(TibetanMoth[51:60,]))
out<-bbsik(ref, que, kmer = 1, UseBuiltModel = FALSE)
out
out$convergence
out$success.rates.ref

data(pineMothITS2) 
ref<-pineMothITS2
que<-pineMothITS2
out<-bbsik(ref, que, kmer = 1, UseBuiltModel = FALSE)
out
out$convergence
out$success.rates.ref



}
\references{
Zhang, A. B., D. S. Sikes, C. Muster, S. Q. Li. (2008). Inferring Species Membership 
using DNA sequences with Back-propagation Neural Networks. Systematic Biology, 57(2):202-215. 
https://academic.oup.com/sysbio/article/57/2/202/1622290
}
\author{
Ai-bing ZHANG, Meng-di HAO, Cai-qing YANG, CNU, Beijing, CHINA. zhangab2008 (at) mail. cnu. edu.cn
}
\keyword{bbsik}
