% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.PPH.R
\name{plot.PPH}
\alias{plot.PPH}
\title{Plot of prior, likelihood, and posterior distributions}
\usage{
\method{plot}{PPH}(x, range = NULL, n = 200, leg.loc = "topleft",
  xlab = "Effect size", ylab = "", ...)
}
\arguments{
\item{x}{A \code{PPH} object created by the \code{pph()} function.}

\item{range}{A numeric vector of length two that sets the range of the
x-axis. Values are passed to \code{xlim}. Sensible default values are used
when \code{range = NULL}.}

\item{n}{An integer that specifies the number of x-values to use when
plotting the distributions.}

\item{leg.loc}{Location of the legend; default is top left. See the
\code{legend()} help pages for all the options. If \code{leg.loc = NULL} the
legend is not plotted.}

\item{xlab, ylab}{Text for the x and y axes labels.}

\item{...}{Other options passed to \code{plot()}.}
}
\value{
Plot of distributions.
}
\description{
Plots the prior, likelihood, and posterior distribution from a
single study.
}
\details{
Plots the prior, likelihood (data), and posterior distribution
calculated from the \code{pph()} function for a single study.
}
\examples{
x <- pph(beta = 5.005, se.beta = 2.05)
plot(x)
}
\seealso{
\code{\link{pph}}
}

