% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastGPfit.R
\name{GP.eigen.funcs.fast.orth}
\alias{GP.eigen.funcs.fast.orth}
\title{Create orthogonal eigen functions}
\usage{
GP.eigen.funcs.fast.orth(grids, poly_degree = 10L, a = 0.01, b = 1)
}
\arguments{
\item{grids}{A matrix where rows represent points and columns are coordinates.}

\item{poly_degree}{A integer number specifies the highest degree of Hermite polynomials. The default value is 10L.}

\item{a}{A positive real number specifies the concentration parameter in the modified exponetial squared kernel. The larger value the more the GP concentrates around the center. The default value is 0.01.}

\item{b}{A positive real number specifies the smoothness parameter in the modeified exponetial squared kernel. The smaller value the smoother the GP is. The default value is 1.0.}
}
\value{
A matrix represents a set of eigen functions evaluated at grid points.
The number of rows is equal to the number of grid points. The number of columns is choose(poly_degree+d,d), where d is the dimnension of the grid points.
}
\description{
Create orthogonal eigen functions based on the standard modified exponential squared correlation kernel and
Gram-Schimit Process
}
\details{
Compute eigen values of the standard modified exponential squared kernel on d-dimensional grids

\eqn{cor(X(s_1),X(s_2)) = \exp{-a*(s_1^2+*s_2^2)-b*(s_1-s_2)^2}}

where \eqn{a} is the concentration parameter and \eqn{b} is the smoothness parameter. The expected ranges of each coordinate is from -6 to 6.
}
\examples{
library(lattice)
grids = GP.generate.grids(d=2L)
Psi_mat = GP.eigen.funcs.fast.orth(grids)
fig = list()
for(i in 1:4){
   fig[[i]] = levelplot(Psi_mat[,i]~grids[,1]+grids[,2])
}
plot(fig[[1]],split=c(1,1,2,2),more=TRUE)
plot(fig[[2]],split=c(1,2,2,2),more=TRUE)
plot(fig[[3]],split=c(2,1,2,2),more=TRUE)
plot(fig[[4]],split=c(2,2,2,2))
}
\author{
Jian Kang <jiankang@umich.edu>
}
