#' A function to calculate sample quantiles
#'
#' Compute quantiles from posterior samples.
#' @param x a numeric vector.
#' @param probs a numeric vector specifying which quantiles are to be computed.
#' @return A numeric vector giving the samples quantiles.
#' @keywords quantiles
#' @importFrom stats quantile
#' @export
#' @examples
#' #generate random samples
#' x<-rnorm(1000)
#' 
#' #compute the 5th, 50th, 95th percentiles
#' quantile_fn(x,probs=c(0.05,0.5,0.95))

quantile_fn<-function(x,probs){
  quantile(x,probs=probs)
}