% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_PLAT.R
\name{fit_PLAT}
\alias{fit_PLAT}
\title{A function to fit the stochastic mortality model "PLAT".}
\usage{
fit_PLAT(
  death,
  expo,
  share_alpha = FALSE,
  share_gamma = FALSE,
  n_iter = 10000,
  family = "nb",
  n.chain = 1,
  thin = 1,
  n.adapt = 1000,
  forecast = FALSE,
  h = 5,
  quiet = FALSE
)
}
\arguments{
\item{death}{death data that has been formatted through the function \code{preparedata_fn}.}

\item{expo}{expo data that has been formatted through the function \code{preparedata_fn}.}

\item{share_alpha}{a logical value indicating if \eqn{a_{x,p}} should be shared across all strata (see details below). Default is \code{FALSE}.}

\item{share_gamma}{a logical value indicating if the cohort parameter \eqn{\gamma_{c,p}} should be shared across all strata (see details below). Default is \code{FALSE}.}

\item{n_iter}{number of iterations to run. Default is \code{n_iter=10000}.}

\item{family}{a string of characters that defines the family function associated with the mortality model. "poisson" would assume that deaths follow a Poisson distribution and use a log link; "binomial" would assume that deaths follow a Binomial distribution and a logit link; "nb" (default) would assume that deaths follow a Negative-Binomial distribution and a log link.}

\item{n.chain}{number of parallel chains for the model.}

\item{thin}{thinning interval for monitoring purposes.}

\item{n.adapt}{the number of iterations for adaptation. See \code{?rjags::adapt} for details.}

\item{forecast}{a logical value indicating if forecast is to be performed (default is \code{FALSE}). See below for details.}

\item{h}{a numeric value giving the number of years to forecast. Default is \code{h=5}.}

\item{quiet}{if TRUE then messages generated during compilation will be suppressed, as well as the progress bar during adaptation.}
}
\value{
A list with components:
\describe{
\item{\code{post_sample}}{An \code{mcmc.list} object containing the posterior samples generated.}
\item{\code{param}}{A vector of character strings describing the names of model parameters.}
\item{\code{death}}{The death data that was used.}
\item{\code{expo}}{The expo data that was used.}
\item{\code{family}}{The family function used.}
\item{\code{forecast}}{A logical value indicating if forecast has been performed.}
\item{\code{h}}{The forecast horizon used.}
}
}
\description{
Carry out Bayesian estimation of the stochastic mortality model referred to as the \bold{"PLAT"} model as proposed by Plat (2009).
}
\details{
The model can be described mathematically as follows:
If \code{family="log"}, then
\deqn{d_{x,t,p} \sim \text{Poisson}(E^c_{x,t,p} m_{x,t,p}) , }
\deqn{\log(m_{x,t,p})=a_{x,p}+k^1_{t,p} + k^2_{t,p}(\bar{x}-x) + k^3_{t,p}(\bar{x}-x)^+ +\gamma_{c,p} , }
where \eqn{c=t-x} is the cohort index, \eqn{\bar{x}} is the mean of \eqn{x}, \eqn{(\bar{x}-x)^+ = \text{max}(\bar{x}-x,0)},
\eqn{d_{x,t,p}} represents the number of deaths at age \eqn{x} in year \eqn{t} of stratum \eqn{p},
while \eqn{E^c_{x,t,p}} and \eqn{m_{x,t,p}} represents respectively the corresponding central exposed to risk and central mortality rate at age \eqn{x} in year \eqn{t} of stratum \eqn{p}.
Similarly, if \code{family="nb"}, then a negative binomial distribution is fitted, i.e.
\deqn{d_{x,t,p} \sim \text{Negative-Binomial}(\phi,\frac{\phi}{\phi+E^c_{x,t,p} m_{x,t,p}}) , }
\deqn{\log(m_{x,t,p})=a_{x,p}+k^1_{t,p} + k^2_{t,p}(\bar{x}-x) + k^3_{t,p}(\bar{x}-x)^+ +\gamma_{c,p} , }
where \eqn{\phi} is the overdispersion parameter. See Wong et al. (2018).
But if \code{family="binomial"}, then
\deqn{d_{x,t,p} \sim \text{Binomial}(E^0_{x,t,p} , q_{x,t,p}) , }
\deqn{\text{logit}(q_{x,t,p})=a_{x,p}+k^1_{t,p} + k^2_{t,p}(\bar{x}-x) + k^3_{t,p}(\bar{x}-x)^+ +\gamma_{c,p} , }
where \eqn{q_{x,t,p}} represents the initial mortality rate at age \eqn{x} in year \eqn{t} of stratum \eqn{p},
while \eqn{E^0_{x,t,p}\approx E^c_{x,t,p}+\frac{1}{2}d_{x,t,p}} is the corresponding initial exposed to risk.
Constraints used are:
\deqn{ \sum_{t} k^1_{t,p} = \sum_{t} k^2_{t,p} = \sum_{t} k^3_{t,p} = 0, \sum_{c} \gamma_{c,p} = \sum_{c} c\gamma_{c,p} = \sum_{c} c^2\gamma_{c,p} = 0 \text{\ \ \ for each stratum }p.}
If \code{share_alpha=TRUE}, then the additive age-specific parameter is the same across all strata \eqn{p}, i. e.
\deqn{a_{x}+k^1_{t,p} + k^2_{t,p}(\bar{x}-x) + k^3_{t,p}(\bar{x}-x)^+ +\gamma_{c,p} .}
If \code{share_gamma=TRUE}, then the cohort parameter is the same across all strata \eqn{p}, i. e.
\deqn{a_{x,p}+k^1_{t,p} + k^2_{t,p}(\bar{x}-x) + k^3_{t,p}(\bar{x}-x)^+ +\gamma_{c} .}
If \code{forecast=TRUE}, then the following time series models are fitted on \eqn{k^1_{t,p}} as follows:
\deqn{k^1_{t,p} = \eta^1_1+\eta^1_2 t +\rho (k^1_{t-1,p}-(\eta^1_1+\eta^1_2 (t-1))) + \epsilon^1_{t,p} \text{ for }p=1,\ldots,P \text{ and } t=1,\ldots,T,}
where \eqn{\epsilon^1_{t,p}\sim N(0,(\sigma^1)_k^2)} for \eqn{t=1,\ldots,T}, while \eqn{\eta^1_1,\eta^1_2,\rho^1,(\sigma^1)_k^2} are additional parameters to be estimated.
Similarly for \eqn{k^2_{t,p}} and \eqn{k^3_{t,p}}.
Also,
\deqn{\gamma_{c,p} = \gamma_{c-1,p}+ \rho_\gamma (\gamma_{c-1,p}-\gamma_{c-2,p}) + \epsilon^\gamma_{c,p} \text{ for }p=1,\ldots,P \text{ and } c=3,\ldots,C,}
\deqn{\gamma_2=\gamma_1+\frac{1}{\sqrt{1-\rho_\gamma^2}}\epsilon^\gamma_{2,p},}
\deqn{\gamma_1=100\epsilon^\gamma_{1,p}}
where \eqn{\epsilon^\gamma_{c,p}\sim N(0,\sigma_\gamma^2)} for \eqn{c=1,\ldots,C}, while \eqn{\rho_\gamma,\sigma_\gamma^2} are additional parameters to be estimated.
Note that the forecasting models are inspired by Wong et al. (2023).
}
\examples{
#load and prepare mortality data
data("dxt_array_product");data("Ext_array_product")
death<-preparedata_fn(dxt_array_product,strat_name = c("ACI","DB","SCI"),ages=35:65)
expo<-preparedata_fn(Ext_array_product,strat_name = c("ACI","DB","SCI"),ages=35:65)

#fit the model (negative-binomial family)
#NOTE: This is a toy example, please run it longer in practice.
fit_PLAT_result<-fit_PLAT(death=death,expo=expo,n_iter=50,n.adapt=50)
head(fit_PLAT_result)

\donttest{
#if sharing the cohorts only (poisson family)
fit_PLAT_result2<-fit_PLAT(death=death,expo=expo,n_iter=1000,family="poisson",share_gamma=TRUE)
head(fit_PLAT_result2)
}
}
\references{
Plat R. (2009). On Stochastic Mortality Modeling. Insurance: Mathematics and Economics, 45(3), 393–404. \doi{https://doi.org/10.1016/j.insmatheco.2009.08.006}

Jackie S. T. Wong, Jonathan J. Forster, and Peter W. F. Smith. (2018). Bayesian mortality forecasting with overdispersion, Insurance: Mathematics and Economics, Volume 2018, Issue 3, 206-221. \doi{https://doi.org/10.1016/j.insmatheco.2017.09.023}

Jackie S. T. Wong, Jonathan J. Forster, and Peter W. F. Smith. (2023). Bayesian model comparison for mortality forecasting, Journal of the Royal Statistical Society Series C: Applied Statistics, Volume 72, Issue 3, 566–586. \doi{https://doi.org/10.1093/jrsssc/qlad021}
}
\concept{PLAT}
\concept{parameter estimation}
\concept{stochastic mortality models}
\keyword{bayesian}
\keyword{estimation}
\keyword{models}
