% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.BayesSurvive.R
\name{coef.BayesSurvive}
\alias{coef.BayesSurvive}
\title{Create a dataframe of estimated coefficients}
\usage{
\method{coef}{BayesSurvive}(
  object,
  MPM = FALSE,
  type = "mean",
  CI = 95,
  SD = FALSE,
  subgroup = 1,
  ...
)
}
\arguments{
\item{object}{an object of class \code{BayesSurvive}}

\item{MPM}{logical value to obtain MPM coefficients. Default: FALSE}

\item{type}{type of point estimates of regression coefficients. One of
\code{c("mean", "median")}. Default is \code{mean}}

\item{CI}{size (level, as a percentage) of the credible interval to report.
Default: 95, i.e. a 95\% credible interval}

\item{SD}{logical value to show each coefficient's standard deviation over
MCMC iterations}

\item{subgroup}{index of the subgroup for visualizing posterior coefficients}

\item{...}{other arguments}
}
\value{
dataframe object
}
\description{
Estimate regression coefficients with posterior mean/median, credible
intervals, standard deviation, or MPM estimates, posterior gammas
}
\examples{

library("BayesSurvive")
set.seed(123)

# Load the example dataset
data("simData", package = "BayesSurvive")

dataset <- list(
  "X" = simData[[1]]$X,
  "t" = simData[[1]]$time,
  "di" = simData[[1]]$status
)

# Initial value: null model without covariates
initial <- list("gamma.ini" = rep(0, ncol(dataset$X)))
# Hyperparameters
hyperparPooled <- list(
  "c0"     = 2, # prior of baseline hazard
  "tau"    = 0.0375, # sd for coefficient prior
  "cb"     = 20, # sd for coefficient prior
  "pi.ga"  = 0.02, # prior variable selection probability for standard Cox models
  "a"      = -4, # hyperparameter in MRF prior
  "b"      = 0.1, # hyperparameter in MRF prior
  "G"      = simData$G # hyperparameter in MRF prior
)

\donttest{
# run Bayesian Cox with graph-structured priors
fit <- BayesSurvive(
  survObj = dataset, hyperpar = hyperparPooled,
  initial = initial, nIter = 50
)

# show posterior coefficients
betas <- coef(fit)
head(betas)
}

}
