/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.alignment;

import dr.evolution.alignment.Alignment;
import dr.evolution.alignment.WrappedAlignment;
import dr.evolution.datatype.AminoAcids;
import dr.evolution.datatype.CodonTable;
import dr.evolution.datatype.Codons;
import dr.evolution.datatype.DataType;
import dr.evolution.datatype.HiddenCodons;
import dr.evolution.datatype.Nucleotides;
import dr.util.XHTMLable;

public class ConvertAlignment
extends WrappedAlignment
implements XHTMLable {
    private DataType dataType = null;
    private CodonTable codonTable = null;

    public ConvertAlignment(DataType dataType) {
        this(dataType, null, null);
    }

    public ConvertAlignment(DataType dataType, CodonTable codonTable) {
        this(dataType, codonTable, null);
    }

    public ConvertAlignment(DataType dataType, Alignment alignment) {
        this(dataType, null, alignment);
    }

    public ConvertAlignment(DataType dataType, CodonTable codonTable, Alignment alignment) {
        super(alignment);
        this.setDataType(dataType);
        this.setCodonTable(codonTable);
        this.setAlignment(alignment);
    }

    public void setCodonTable(CodonTable codonTable) {
        this.codonTable = codonTable;
    }

    public void setAlignment(Alignment alignment) {
        if (this.dataType == null) {
            this.dataType = alignment.getDataType();
        }
        this.alignment = alignment;
        int n = this.dataType.getType();
        int n2 = alignment.getDataType().getType();
        if (n2 == 0) {
            if (n != 2 && n != 1) {
                throw new RuntimeException("Incompatible alignment DataType for ConversionAlignment");
            }
        } else if (n2 == 2) {
            if (n != 1 && n != 0) {
                System.err.println("originalType = " + n2);
                System.err.println("newType = " + n);
                throw new RuntimeException("Incompatible alignment DataType for ConversionAlignment");
            }
        } else {
            throw new RuntimeException("Incompatible alignment DataType for ConversionAlignment");
        }
    }

    @Override
    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public int getSiteCount() {
        if (this.alignment == null) {
            throw new RuntimeException("ConvertAlignment has no alignment");
        }
        int n = this.alignment.getDataType().getType();
        int n2 = this.alignment.getSiteCount();
        if (n == 0) {
            n2 /= 3;
        }
        return n2;
    }

    @Override
    public int getState(int n, int n2) {
        if (this.alignment == null) {
            throw new RuntimeException("ConvertAlignment has no alignment");
        }
        int n3 = this.dataType.getType();
        int n4 = this.alignment.getDataType().getType();
        int n5 = 0;
        if (n4 == 0) {
            int n6 = n2 * 3;
            int n7 = this.alignment.getState(n, n6);
            int n8 = this.alignment.getState(n, n6 + 1);
            int n9 = this.alignment.getState(n, n6 + 2);
            n5 = n3 == 2 ? (this.dataType instanceof HiddenCodons ? ((HiddenCodons)this.dataType).getState(n7, n8, n9) : ((Codons)this.dataType).getState(n7, n8, n9)) : this.codonTable.getAminoAcidState(((Codons)this.dataType).getCanonicalState(((Codons)this.dataType).getState(n7, n8, n9)));
        } else if (n4 == 2) {
            if (n3 == 1) {
                n5 = this.codonTable.getAminoAcidState(this.alignment.getState(n, n2));
            } else {
                String string = this.alignment.getAlignedSequenceString(n);
                n5 = Nucleotides.INSTANCE.getState(string.charAt(n2));
            }
        }
        return n5;
    }

    @Override
    public String toXHTML() {
        int n;
        int n2;
        String string = "<p><em>Converted Alignment</em> data type = ";
        string = string + this.getDataType().getDescription();
        string = string + ", no. taxa = ";
        string = string + this.getTaxonCount();
        string = string + ", no. sites = ";
        string = string + this.getSiteCount();
        string = string + "</p>";
        string = string + "<pre>";
        int n3 = 0;
        for (n2 = 0; n2 < this.getTaxonCount(); ++n2) {
            n = this.getTaxonId(n2).length();
            if (n <= n3) continue;
            n3 = n;
        }
        int n4 = this.getDataType().getType();
        for (int i = 0; i < this.getTaxonCount(); ++i) {
            int n5;
            n = this.getTaxonId(i).length();
            string = string + this.getTaxonId(i);
            for (n5 = n; n5 <= n3; ++n5) {
                string = string + " ";
            }
            n2 = this.getSiteCount();
            for (n5 = 0; n5 < n2; ++n5) {
                int n6 = this.getState(i, n5);
                string = n4 == 2 ? string + Codons.UNIVERSAL.getTriplet(n6) + " " : string + AminoAcids.INSTANCE.getTriplet(n6) + " ";
            }
            string = string + "\n";
        }
        string = string + "</pre>";
        return string;
    }
}

