/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evolution.coalescent.Coalescent;
import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.coalescent.ScaledDemographic;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.MultiLociTreeSet;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import dr.math.Binomial;
import dr.util.ComparableDouble;
import dr.util.HeapSort;
import java.util.ArrayList;
import java.util.Arrays;

@Deprecated
public class OldAbstractCoalescentLikelihood
extends AbstractModelLikelihood
implements Units {
    protected MultiLociTreeSet treesSet = null;
    protected boolean buildIntervalNodeMapping = false;
    private DemographicModel demoModel = null;
    Tree tree = null;
    double[] intervals;
    private double[] storedIntervals;
    int[] lineageCounts;
    private int[] storedLineageCounts;
    IntervalNodeMapping intervalNodeMapping;
    boolean intervalsKnown = false;
    private boolean storedIntervalsKnown = false;
    double logLikelihood;
    private double storedLogLikelihood;
    boolean likelihoodKnown = false;
    private boolean storedLikelihoodKnown = false;
    int intervalCount = 0;
    private int storedIntervalCount = 0;

    public OldAbstractCoalescentLikelihood(Tree tree, DemographicModel demographicModel) {
        this("coalescentLikelihood", tree, demographicModel, true);
    }

    public OldAbstractCoalescentLikelihood(MultiLociTreeSet multiLociTreeSet, DemographicModel demographicModel) {
        super("coalescentLikelihood");
        this.demoModel = demographicModel;
        this.tree = null;
        this.treesSet = multiLociTreeSet;
        if (demographicModel != null) {
            this.addModel(demographicModel);
        }
        for (int i = 0; i < multiLociTreeSet.nLoci(); ++i) {
            Tree tree = multiLociTreeSet.getTree(i);
            if (!(tree instanceof Model)) continue;
            this.addModel((Model)((Object)tree));
        }
    }

    public OldAbstractCoalescentLikelihood(String string, Tree tree, DemographicModel demographicModel, boolean bl) {
        this(string, tree, demographicModel, bl, false);
    }

    public OldAbstractCoalescentLikelihood(String string, Tree tree, DemographicModel demographicModel, boolean bl, boolean bl2) {
        super(string);
        this.demoModel = demographicModel;
        this.tree = tree;
        if (tree instanceof TreeModel) {
            this.addModel((TreeModel)tree);
        }
        if (demographicModel != null) {
            this.addModel(demographicModel);
        }
        this.buildIntervalNodeMapping = bl2;
        if (bl) {
            this.setupIntervals();
        }
        this.addStatistic(new DeltaStatistic());
    }

    OldAbstractCoalescentLikelihood(String string) {
        super(string);
    }

    public NodeRef getMRCAOfCoalescent(Tree tree) {
        return tree.getRoot();
    }

    public NodeRef[] getExcludedMRCAs(Tree tree) {
        return null;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.tree) {
            this.intervalsKnown = false;
        }
        this.likelihoodKnown = false;
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
        if (this.tree != null) {
            System.arraycopy(this.intervals, 0, this.storedIntervals, 0, this.intervals.length);
            System.arraycopy(this.lineageCounts, 0, this.storedLineageCounts, 0, this.lineageCounts.length);
            this.storedIntervalsKnown = this.intervalsKnown;
            this.storedIntervalCount = this.intervalCount;
            this.storedLikelihoodKnown = this.likelihoodKnown;
        } else if (this.treesSet != null) {
            this.treesSet.storeTheState();
        }
        this.storedLogLikelihood = this.logLikelihood;
    }

    @Override
    protected void restoreState() {
        if (this.tree != null) {
            System.arraycopy(this.storedIntervals, 0, this.intervals, 0, this.storedIntervals.length);
            System.arraycopy(this.storedLineageCounts, 0, this.lineageCounts, 0, this.storedLineageCounts.length);
            this.intervalsKnown = this.storedIntervalsKnown;
            this.intervalCount = this.storedIntervalCount;
        } else if (this.treesSet != null) {
            this.treesSet.restoreTheState();
        }
        this.likelihoodKnown = this.storedLikelihoodKnown;
        this.logLikelihood = this.storedLogLikelihood;
        if (!this.intervalsKnown) {
            this.likelihoodKnown = false;
        }
    }

    @Override
    protected final void acceptState() {
    }

    @Override
    public final Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    @Override
    public final void makeDirty() {
        this.likelihoodKnown = false;
        this.intervalsKnown = false;
    }

    public double calculateLogLikelihood() {
        if (this.treesSet != null) {
            int n = this.treesSet.nLoci();
            DemographicFunction demographicFunction = this.demoModel.getDemographicFunction();
            double d = 0.0;
            for (int i = 0; i < n; ++i) {
                double d2 = this.treesSet.getPopulationFactor(i);
                DemographicFunction demographicFunction2 = d2 != 1.0 ? new ScaledDemographic(demographicFunction, d2) : demographicFunction;
                d += Coalescent.calculateLogLikelihood(this.treesSet.getTreeIntervals(i), demographicFunction2);
            }
            return d;
        }
        if (!this.intervalsKnown) {
            this.setupIntervals();
        }
        if (this.demoModel == null) {
            return this.calculateAnalyticalLogLikelihood();
        }
        double d = 0.0;
        double d3 = 0.0;
        DemographicFunction demographicFunction = this.demoModel.getDemographicFunction();
        for (int i = 0; i < this.intervalCount; ++i) {
            d += OldAbstractCoalescentLikelihood.calculateIntervalLikelihood(demographicFunction, this.intervals[i], d3, this.lineageCounts[i], this.getIntervalType(i));
            int n = this.getCoalescentEvents(i) - 1;
            for (int j = 0; j < n; ++j) {
                d += OldAbstractCoalescentLikelihood.calculateIntervalLikelihood(demographicFunction, 0.0, d3, this.lineageCounts[i] - j - 1, CoalescentEventType.COALESCENT);
            }
            d3 += this.intervals[i];
        }
        return d;
    }

    private double calculateAnalyticalLogLikelihood() {
        double d = this.getLambda();
        int n = this.tree.getExternalNodeCount();
        return (double)(-(n - 1)) * Math.log(d);
    }

    public final double calculateIntervalLikelihood(DemographicFunction demographicFunction, double d, double d2, int n) {
        return OldAbstractCoalescentLikelihood.calculateIntervalLikelihood(demographicFunction, d, d2, n, CoalescentEventType.COALESCENT);
    }

    public static double calculateIntervalLikelihood(DemographicFunction demographicFunction, double d, double d2, int n, CoalescentEventType coalescentEventType) {
        double d3 = d + d2;
        double d4 = demographicFunction.getIntegral(d2, d3);
        double d5 = Binomial.choose2(n);
        double d6 = -d5 * d4;
        switch (coalescentEventType) {
            case COALESCENT: {
                double d7 = demographicFunction.getLogDemographic(d3);
                d6 += -d7;
                break;
            }
        }
        return d6;
    }

    public final double calculateIntervalShapeParameter(DemographicFunction demographicFunction, double d, double d2, int n, CoalescentEventType coalescentEventType) {
        switch (coalescentEventType) {
            case COALESCENT: {
                return 1.0;
            }
            case NEW_SAMPLE: {
                return 0.0;
            }
        }
        throw new Error("Unknown event found");
    }

    public final double calculateIntervalRateParameter(DemographicFunction demographicFunction, double d, double d2, int n, CoalescentEventType coalescentEventType) {
        double d3 = d + d2;
        double d4 = demographicFunction.getIntegral(d2, d3);
        return Binomial.choose2(n) * d4;
    }

    private double getLambda() {
        double d = 0.0;
        for (int i = 0; i < this.getIntervalCount(); ++i) {
            d += this.intervals[i] * (double)this.lineageCounts[i];
        }
        return d /= 2.0;
    }

    public final void setupIntervals() {
        if (this.intervals == null) {
            int n = this.tree.getNodeCount();
            this.intervals = new double[n];
            this.lineageCounts = new int[n];
            this.storedIntervals = new double[n];
            this.storedLineageCounts = new int[n];
            this.intervalNodeMapping = this.buildIntervalNodeMapping ? new IntervalNodeMapping.Default(this.tree.getNodeCount(), this.tree) : new IntervalNodeMapping.None();
        }
        XTreeIntervals xTreeIntervals = new XTreeIntervals(this.intervals, this.lineageCounts);
        OldAbstractCoalescentLikelihood.getTreeIntervals(this.tree, this.getMRCAOfCoalescent(this.tree), this.getExcludedMRCAs(this.tree), xTreeIntervals, this.intervalNodeMapping);
        this.intervalCount = xTreeIntervals.nIntervals;
        this.intervalsKnown = true;
    }

    private static void collectAllTimes(Tree tree, NodeRef nodeRef, NodeRef[] nodeRefArray, ArrayList<ComparableDouble> arrayList, ArrayList<Integer> arrayList2, ArrayList<Integer> arrayList3) {
        arrayList.add(new ComparableDouble(tree.getNodeHeight(nodeRef)));
        arrayList2.add(tree.getChildCount(nodeRef));
        arrayList3.add(nodeRef.getNumber());
        for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
            NodeRef nodeRef2 = tree.getChild(nodeRef, i);
            if (nodeRefArray == null) {
                OldAbstractCoalescentLikelihood.collectAllTimes(tree, nodeRef2, nodeRefArray, arrayList, arrayList2, arrayList3);
                continue;
            }
            boolean bl = true;
            for (NodeRef nodeRef3 : nodeRefArray) {
                if (nodeRef3.getNumber() != nodeRef2.getNumber()) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            OldAbstractCoalescentLikelihood.collectAllTimes(tree, nodeRef2, nodeRefArray, arrayList, arrayList2, arrayList3);
        }
    }

    private static void getTreeIntervals(Tree tree, NodeRef nodeRef, NodeRef[] nodeRefArray, XTreeIntervals xTreeIntervals, IntervalNodeMapping intervalNodeMapping) {
        double d = 1.0E-9;
        ArrayList<ComparableDouble> arrayList = new ArrayList<ComparableDouble>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        OldAbstractCoalescentLikelihood.collectAllTimes(tree, nodeRef, nodeRefArray, arrayList, arrayList2, arrayList3);
        int[] nArray = new int[arrayList.size()];
        HeapSort.sort(arrayList, nArray);
        double[] dArray = xTreeIntervals.intervals;
        int[] nArray2 = xTreeIntervals.lineagesCount;
        intervalNodeMapping.initializeMaps();
        double d2 = arrayList.get(nArray[0]).doubleValue();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n2 < arrayList.size()) {
            int n4;
            double d3;
            int n5 = 0;
            int n6 = 0;
            double d4 = d3 = arrayList.get(nArray[n2]).doubleValue();
            intervalNodeMapping.addNode(arrayList3.get(nArray[n2]));
            while (Math.abs(d4 - d3) < d) {
                n4 = arrayList2.get(nArray[n2]);
                if (n4 == 0) {
                    ++n6;
                } else {
                    n5 += n4 - 1;
                }
                if (++n2 == arrayList.size()) break;
                d4 = arrayList.get(nArray[n2]).doubleValue();
                intervalNodeMapping.addNode(arrayList3.get(nArray[n2]));
            }
            n4 = 0;
            if (n6 > 0) {
                if (n3 > 0 || d3 - d2 > d) {
                    dArray[n3] = d3 - d2;
                    nArray2[n3] = n;
                    ++n3;
                    n4 = 1;
                }
                d2 = d3;
            }
            n += n6;
            if (n5 > 0) {
                dArray[n3] = d3 - d2;
                nArray2[n3] = n;
                d2 = d3;
                if (n4 != 0 || ++n3 == 1) {
                    intervalNodeMapping.addNode(arrayList3.get(nArray[n2]));
                }
            }
            n -= n5;
        }
        intervalNodeMapping.setIntervalStartIndices(n3);
        xTreeIntervals.nIntervals = n3;
    }

    public final int getIntervalCount() {
        return this.intervalCount;
    }

    public final double getInterval(int n) {
        if (n >= this.intervalCount) {
            throw new IllegalArgumentException();
        }
        return this.intervals[n];
    }

    public final int getLineageCount(int n) {
        if (n >= this.intervalCount) {
            throw new IllegalArgumentException();
        }
        return this.lineageCounts[n];
    }

    public final int getCoalescentEvents(int n) {
        if (n >= this.intervalCount) {
            throw new IllegalArgumentException();
        }
        if (n < this.intervalCount - 1) {
            return this.lineageCounts[n] - this.lineageCounts[n + 1];
        }
        return this.lineageCounts[n] - 1;
    }

    public final CoalescentEventType getIntervalType(int n) {
        if (n >= this.intervalCount) {
            throw new IllegalArgumentException();
        }
        int n2 = this.getCoalescentEvents(n);
        if (n2 > 0) {
            return CoalescentEventType.COALESCENT;
        }
        if (n2 < 0) {
            return CoalescentEventType.NEW_SAMPLE;
        }
        return CoalescentEventType.NOTHING;
    }

    public final double getTotalHeight() {
        double d = 0.0;
        for (int i = 0; i < this.intervalCount; ++i) {
            d += this.intervals[i];
        }
        return d;
    }

    public final boolean isBinaryCoalescent() {
        for (int i = 0; i < this.intervalCount; ++i) {
            if (this.getCoalescentEvents(i) == 1) continue;
            return false;
        }
        return true;
    }

    public final boolean isCoalescentOnly() {
        for (int i = 0; i < this.intervalCount; ++i) {
            if (this.getCoalescentEvents(i) >= 1) continue;
            return false;
        }
        return true;
    }

    public IntervalNodeMapping getIntervalNodeMapping() {
        return this.intervalNodeMapping;
    }

    @Override
    public String toString() {
        return this.getId();
    }

    @Override
    public final void setUnits(Units.Type type) {
        this.demoModel.setUnits(type);
    }

    @Override
    public final Units.Type getUnits() {
        return this.demoModel.getUnits();
    }

    public final boolean getIntervalsKnown() {
        return this.intervalsKnown;
    }

    public class DeltaStatistic
    extends Statistic.Abstract {
        public DeltaStatistic() {
            super("delta");
        }

        @Override
        public int getDimension() {
            return 1;
        }

        @Override
        public double getStatisticValue(int n) {
            throw new RuntimeException("Not implemented");
        }
    }

    public static enum CoalescentEventType {
        COALESCENT,
        NEW_SAMPLE,
        NOTHING;

    }

    public static interface IntervalNodeMapping {
        public void addNode(int var1);

        public void setIntervalStartIndices(int var1);

        public void initializeMaps();

        public int[] getIntervalsForNode(int var1);

        public int[] getNodeNumbersForInterval(int var1);

        public double[] sortByNodeNumbers(double[] var1);

        public static class None
        implements IntervalNodeMapping {
            @Override
            public void addNode(int n) {
            }

            @Override
            public void setIntervalStartIndices(int n) {
            }

            @Override
            public void initializeMaps() {
            }

            @Override
            public int[] getIntervalsForNode(int n) {
                throw new RuntimeException("No intervalNodeMapping available. This function should not be called.");
            }

            @Override
            public int[] getNodeNumbersForInterval(int n) {
                throw new RuntimeException("No intervalNodeMapping available. This function should not be called.");
            }

            @Override
            public double[] sortByNodeNumbers(double[] dArray) {
                throw new RuntimeException("No intervalNodeMapping available. This function should not be called.");
            }
        }

        public static class Default
        implements IntervalNodeMapping {
            final int[] nodeNumbersInIntervals;
            final int[] intervalStartIndices;
            final int[] intervalNumberOfNodes;
            private int nextIndex = 0;
            private int nIntervals;
            private Tree tree;
            private final int maxIndicesPerNode = 3;

            public Default(int n, Tree tree) {
                this.nodeNumbersInIntervals = new int[3 * n];
                this.intervalStartIndices = new int[n];
                this.intervalNumberOfNodes = new int[3 * n];
                this.tree = tree;
            }

            @Override
            public void addNode(int n) {
                this.nodeNumbersInIntervals[this.nextIndex] = n;
                ++this.nextIndex;
            }

            private void mapNodeInterval(int n, int n2) {
                int n3;
                for (n3 = 0; n3 < 3; ++n3) {
                    if (this.intervalNumberOfNodes[3 * n + n3] != -1) continue;
                    this.intervalNumberOfNodes[3 * n + n3] = n2;
                    break;
                }
                if (n3 == 3) {
                    throw new RuntimeException("The node appears in more than3 intervals!");
                }
            }

            @Override
            public void setIntervalStartIndices(int n) {
                if (this.nodeNumbersInIntervals[this.nextIndex - 1] == this.nodeNumbersInIntervals[this.nextIndex - 2]) {
                    this.nodeNumbersInIntervals[this.nextIndex - 1] = 0;
                    --this.nextIndex;
                }
                int n2 = 1;
                this.mapNodeInterval(this.nodeNumbersInIntervals[0], 0);
                for (int i = 1; i < n; ++i) {
                    while (this.nodeNumbersInIntervals[n2] != this.nodeNumbersInIntervals[n2 - 1]) {
                        this.mapNodeInterval(this.nodeNumbersInIntervals[n2], i - 1);
                        ++n2;
                    }
                    this.intervalStartIndices[i] = n2;
                    this.mapNodeInterval(this.nodeNumbersInIntervals[n2], i);
                    ++n2;
                }
                while (n2 < this.nextIndex) {
                    this.mapNodeInterval(this.nodeNumbersInIntervals[n2], n - 1);
                    ++n2;
                }
                this.nIntervals = n;
            }

            @Override
            public void initializeMaps() {
                Arrays.fill(this.intervalNumberOfNodes, -1);
                Arrays.fill(this.intervalStartIndices, 0);
                Arrays.fill(this.nodeNumbersInIntervals, 0);
                this.nextIndex = 0;
            }

            @Override
            public int[] getIntervalsForNode(int n) {
                int n2 = 0;
                while (this.intervalNumberOfNodes[3 * n + n2] != -1) {
                    ++n2;
                }
                int[] nArray = new int[n2];
                for (int i = 0; i < n2; ++i) {
                    nArray[i] = this.intervalNumberOfNodes[3 * n + i];
                }
                return nArray;
            }

            @Override
            public int[] getNodeNumbersForInterval(int n) {
                assert (n < this.nIntervals);
                int n2 = this.intervalStartIndices[n];
                int n3 = n == this.nIntervals - 1 ? this.nextIndex - 1 : this.intervalStartIndices[n + 1] - 1;
                int[] nArray = new int[n3 - n2 + 1];
                for (int i = 0; i < n3 - n2 + 1; ++i) {
                    nArray[i] = this.nodeNumbersInIntervals[n2 + i];
                }
                return nArray;
            }

            @Override
            public double[] sortByNodeNumbers(double[] dArray) {
                int n;
                double[] dArray2 = new double[dArray.length];
                int[] nArray = new int[dArray.length];
                ArrayList<ComparableDouble> arrayList = new ArrayList<ComparableDouble>();
                for (n = 0; n < nArray.length; ++n) {
                    arrayList.add(new ComparableDouble(this.getIntervalsForNode(n + this.tree.getExternalNodeCount())[0]));
                }
                HeapSort.sort(arrayList, nArray);
                for (n = 0; n < nArray.length; ++n) {
                    dArray2[nArray[n]] = dArray[n];
                }
                return dArray2;
            }
        }
    }

    private class XTreeIntervals {
        int nIntervals;
        final int[] lineagesCount;
        final double[] intervals;

        public XTreeIntervals(double[] dArray, int[] nArray) {
            this.intervals = dArray;
            this.lineagesCount = nArray;
        }
    }
}

