/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.transmission;

import dr.evolution.coalescent.Coalescent;
import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.coalescent.Intervals;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.evomodel.transmission.TransmissionDemographicModel;
import dr.evomodel.transmission.TransmissionHistoryModel;
import dr.evomodel.tree.TreeModel;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Variable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import dr.xml.XORRule;

public class TransmissionLikelihood
extends AbstractModelLikelihood
implements Units {
    public static final String TRANSMISSION_LIKELIHOOD = "transmissionLikelihood";
    public static final String SOURCE_PATIENT = "sourcePatient";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("sourcePatient", DemographicModel.class, "This describes the demographic process for the source donor patient."), new ElementRule(TransmissionDemographicModel.class, "This describes the demographic process for the recipient patients."), new XORRule(new ElementRule("hostTree", new XMLSyntaxRule[]{new ElementRule(Tree.class)}), new ElementRule(TransmissionHistoryModel.class, "This describes the transmission history of the patients.")), new ElementRule("parasiteTree", new XMLSyntaxRule[]{new ElementRule(Tree.class)})};

        @Override
        public String getParserName() {
            return TransmissionLikelihood.TRANSMISSION_LIKELIHOOD;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            DemographicModel demographicModel = (DemographicModel)xMLObject.getElementFirstChild(TransmissionLikelihood.SOURCE_PATIENT);
            TransmissionDemographicModel transmissionDemographicModel = (TransmissionDemographicModel)xMLObject.getChild(TransmissionDemographicModel.class);
            Tree tree = (Tree)xMLObject.getElementFirstChild("parasiteTree");
            TransmissionLikelihood transmissionLikelihood = null;
            if (xMLObject.getChild(TransmissionHistoryModel.class) != null) {
                TransmissionHistoryModel transmissionHistoryModel = (TransmissionHistoryModel)xMLObject.getChild(TransmissionHistoryModel.class);
                try {
                    transmissionLikelihood = new TransmissionLikelihood(transmissionHistoryModel, tree, demographicModel, transmissionDemographicModel);
                }
                catch (TaxonList.MissingTaxonException missingTaxonException) {
                    throw new XMLParseException(missingTaxonException.toString());
                }
            }
            Tree tree2 = (Tree)xMLObject.getElementFirstChild("hostTree");
            try {
                transmissionLikelihood = new TransmissionLikelihood(tree2, tree, demographicModel, transmissionDemographicModel);
            }
            catch (TaxonList.MissingTaxonException missingTaxonException) {
                throw new XMLParseException(missingTaxonException.toString());
            }
            return transmissionLikelihood;
        }

        @Override
        public String getParserDescription() {
            return "This element represents a likelihood function for transmission.";
        }

        @Override
        public Class getReturnType() {
            return TransmissionLikelihood.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private DemographicModel sourceDemographic = null;
    private TransmissionDemographicModel transmissionModel = null;
    private Tree hostTree = null;
    private TransmissionHistoryModel transmissionHistoryModel = null;
    private Tree virusTree = null;
    private int hostCount;
    private Intervals[] intervals;
    private int[] donorHost;
    private double[] transmissionTime;
    private double[] donorSize;
    private boolean likelihoodKnown = false;
    private double logLikelihood;

    public TransmissionLikelihood(Tree tree, Tree tree2, DemographicModel demographicModel, TransmissionDemographicModel transmissionDemographicModel) throws TaxonList.MissingTaxonException {
        this(TRANSMISSION_LIKELIHOOD, tree, tree2, demographicModel, transmissionDemographicModel);
    }

    public TransmissionLikelihood(String string, Tree tree, Tree tree2, DemographicModel demographicModel, TransmissionDemographicModel transmissionDemographicModel) throws TaxonList.MissingTaxonException {
        super(string);
        this.hostTree = tree;
        if (tree instanceof TreeModel) {
            this.addModel((TreeModel)tree);
        }
        this.virusTree = tree2;
        if (tree2 instanceof TreeModel) {
            this.addModel((TreeModel)tree2);
        }
        this.sourceDemographic = demographicModel;
        this.addModel(demographicModel);
        this.transmissionModel = transmissionDemographicModel;
        this.addModel(transmissionDemographicModel);
        for (int i = 0; i < tree2.getExternalNodeCount(); ++i) {
            Taxon taxon = (Taxon)tree2.getTaxonAttribute(i, "host");
            if (taxon == null) {
                throw new TaxonList.MissingTaxonException("One or more of the viruses tree's taxa are missing the 'host' attribute");
            }
            int n = tree.getTaxonIndex(taxon);
            if (n != -1) continue;
            throw new TaxonList.MissingTaxonException("One of the viruses tree's host attribute, " + taxon.getId() + ", was not found as a taxon in the host tree");
        }
        this.setupHosts();
    }

    public TransmissionLikelihood(TransmissionHistoryModel transmissionHistoryModel, Tree tree, DemographicModel demographicModel, TransmissionDemographicModel transmissionDemographicModel) throws TaxonList.MissingTaxonException {
        this(TRANSMISSION_LIKELIHOOD, transmissionHistoryModel, tree, demographicModel, transmissionDemographicModel);
    }

    public TransmissionLikelihood(String string, TransmissionHistoryModel transmissionHistoryModel, Tree tree, DemographicModel demographicModel, TransmissionDemographicModel transmissionDemographicModel) throws TaxonList.MissingTaxonException {
        super(string);
        this.transmissionHistoryModel = transmissionHistoryModel;
        this.addModel(transmissionHistoryModel);
        this.virusTree = tree;
        if (tree instanceof TreeModel) {
            this.addModel((TreeModel)tree);
        }
        this.sourceDemographic = demographicModel;
        this.addModel(demographicModel);
        this.transmissionModel = transmissionDemographicModel;
        this.addModel(transmissionDemographicModel);
        for (int i = 0; i < tree.getExternalNodeCount(); ++i) {
            Taxon taxon = (Taxon)tree.getTaxonAttribute(i, "host");
            if (taxon == null) {
                throw new TaxonList.MissingTaxonException("One or more of the viruses tree's taxa are missing the 'host' attribute");
            }
            int n = transmissionHistoryModel.getHostIndex(taxon);
            if (n != -1) continue;
            throw new TaxonList.MissingTaxonException("One of the viruses tree's host attribute, " + taxon.getId() + ", was not found as a taxon in the transmission history");
        }
        this.setupHosts();
    }

    private void setupHosts() {
        int n;
        this.hostCount = this.transmissionHistoryModel != null ? this.transmissionHistoryModel.getHostCount() : this.hostTree.getTaxonCount();
        this.intervals = new Intervals[this.hostCount];
        for (n = 0; n < this.hostCount; ++n) {
            this.intervals[n] = new Intervals(this.virusTree.getExternalNodeCount() * 3);
        }
        this.donorHost = new int[this.hostCount];
        this.donorHost[0] = -1;
        this.transmissionTime = new double[this.hostCount];
        this.transmissionTime[0] = Double.POSITIVE_INFINITY;
        this.donorSize = new double[this.hostCount];
        if (this.transmissionHistoryModel != null) {
            for (n = 0; n < this.transmissionHistoryModel.getTransmissionEventCount(); ++n) {
                TransmissionHistoryModel.TransmissionEvent transmissionEvent = this.transmissionHistoryModel.getTransmissionEvent(n);
                int n2 = this.transmissionHistoryModel.getHostIndex(transmissionEvent.getDonor());
                int n3 = this.transmissionHistoryModel.getHostIndex(transmissionEvent.getRecipient());
                this.donorHost[n3] = n2;
                this.transmissionTime[n3] = transmissionEvent.getTransmissionTime();
            }
        } else {
            this.setupHostsTree(this.hostTree.getRoot());
        }
    }

    private int setupHostsTree(NodeRef nodeRef) {
        int n;
        if (this.hostTree.isExternal(nodeRef)) {
            n = nodeRef.getNumber();
        } else {
            int n2 = this.setupHostsTree(this.hostTree.getChild(nodeRef, 0));
            int n3 = this.setupHostsTree(this.hostTree.getChild(nodeRef, 1));
            this.donorHost[n3] = n2;
            this.transmissionTime[n3] = this.hostTree.getNodeHeight(nodeRef);
            n = n2;
        }
        return n;
    }

    @Override
    protected final void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.virusTree || model == this.hostTree || model == this.transmissionHistoryModel) {
            // empty if block
        }
        this.likelihoodKnown = false;
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected final void storeState() {
    }

    @Override
    protected final void restoreState() {
        this.likelihoodKnown = false;
    }

    @Override
    protected final void acceptState() {
    }

    @Override
    public final Model getModel() {
        return this;
    }

    @Override
    public final double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    @Override
    public final void makeDirty() {
        this.likelihoodKnown = false;
    }

    public double calculateLogLikelihood() {
        int n;
        this.makeDirty();
        this.setupHosts();
        for (n = 0; n < this.hostCount; ++n) {
            this.intervals[n].resetEvents();
            this.donorSize[n] = -1.0;
        }
        try {
            this.setupIntervals(this.virusTree.getRoot());
        }
        catch (IncompatibleException incompatibleException) {
            return Double.NEGATIVE_INFINITY;
        }
        for (n = 0; n < this.hostCount; ++n) {
            this.donorSize[n] = -1.0;
        }
        DemographicFunction demographicFunction = this.sourceDemographic.getDemographicFunction();
        double d = Coalescent.calculateLogLikelihood(this.intervals[0], demographicFunction);
        for (int i = 1; i < this.hostCount; ++i) {
            double d2 = this.getDonorSize(i);
            demographicFunction = this.transmissionModel.getDemographicFunction(this.transmissionTime[i], d2, i);
            d += Coalescent.calculateLogLikelihood(this.intervals[i], demographicFunction);
        }
        return d;
    }

    private double getDonorSize(int n) {
        DemographicFunction demographicFunction;
        if (this.donorSize[n] > 0.0) {
            return this.donorSize[n];
        }
        if (this.donorHost[n] == 0) {
            demographicFunction = this.sourceDemographic.getDemographicFunction();
        } else {
            double d = this.getDonorSize(this.donorHost[n]);
            demographicFunction = this.transmissionModel.getDemographicFunction(this.transmissionTime[n], d, n);
        }
        this.donorSize[n] = demographicFunction.getDemographic(this.transmissionTime[n]);
        return this.donorSize[n];
    }

    private int setupIntervals(NodeRef nodeRef) throws IncompatibleException {
        int n;
        double d = this.virusTree.getNodeHeight(nodeRef);
        if (this.virusTree.isExternal(nodeRef)) {
            Taxon taxon = (Taxon)this.virusTree.getTaxonAttribute(nodeRef.getNumber(), "host");
            n = this.transmissionHistoryModel != null ? this.transmissionHistoryModel.getHostIndex(taxon) : this.hostTree.getTaxonIndex(taxon);
            this.intervals[n].addSampleEvent(d);
        } else {
            double d2;
            int n2 = this.setupIntervals(this.virusTree.getChild(nodeRef, 0));
            int n3 = this.setupIntervals(this.virusTree.getChild(nodeRef, 1));
            while (d > this.transmissionTime[n2]) {
                d2 = this.transmissionTime[n2];
                this.intervals[n2].addNothingEvent(d2);
                n2 = this.donorHost[n2];
                this.intervals[n2].addSampleEvent(d2);
            }
            while (d > this.transmissionTime[n3]) {
                d2 = this.transmissionTime[n3];
                this.intervals[n3].addNothingEvent(d2);
                n3 = this.donorHost[n3];
                this.intervals[n3].addSampleEvent(d2);
            }
            if (n2 != n3) {
                throw new IncompatibleException("Virus tree is not compatible with transmission history");
            }
            n = n2;
            this.intervals[n].addCoalescentEvent(d);
        }
        return n;
    }

    @Override
    public final void setUnits(Units.Type type) {
        this.transmissionModel.setUnits(type);
    }

    @Override
    public final Units.Type getUnits() {
        return this.transmissionModel.getUnits();
    }

    class IncompatibleException
    extends Exception {
        private static final long serialVersionUID = 8439923064799668934L;

        public IncompatibleException(String string) {
            super(string);
        }
    }
}

