/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.continuous;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.treedatalikelihood.continuous.ContinuousDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.continuous.ContinuousTraitPartialsProvider;
import dr.evomodel.treedatalikelihood.continuous.HashedMissingArray;
import dr.evomodel.treedatalikelihood.continuous.MultivariateTraitDebugUtilities;
import dr.evomodel.treedatalikelihood.continuous.cdi.PrecisionType;
import dr.evomodel.treedatalikelihood.preorder.ContinuousExtensionDelegate;
import dr.evomodel.treedatalikelihood.preorder.ModelExtensionProvider;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.CompoundParameter;
import dr.inference.model.DiagonalMatrix;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.KroneckerOperation;
import dr.math.distributions.MultivariateNormalDistribution;
import dr.math.matrixAlgebra.IllegalDimension;
import dr.math.matrixAlgebra.Matrix;
import dr.math.matrixAlgebra.Vector;
import dr.math.matrixAlgebra.WrappedVector;
import dr.math.matrixAlgebra.missingData.InversionResult;
import dr.math.matrixAlgebra.missingData.MissingOps;
import dr.util.TaskPool;
import dr.xml.Reportable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class IntegratedFactorAnalysisLikelihood
extends AbstractModelLikelihood
implements ContinuousTraitPartialsProvider,
ModelExtensionProvider.NormalExtensionProvider,
Reportable {
    private final int[] fullyObservedTraits;
    private final int[] partiallyMissingTraits;
    private boolean observedInnerProductKnown = false;
    private final DenseMatrix64F observedInnerProduct;
    private static final PrecisionType precisionType = PrecisionType.FULL;
    private boolean[] missingTraitIndicators = null;
    private String tipTraitName;
    private final double nuggetPrecision;
    private final TaskPool taskPool;
    private static final boolean TIMING = false;
    private static final boolean USE_INNER_PRODUCT_CACHE = true;
    private Map<HashedMissingArray, DenseMatrix64F> precisionMatrixMap = new HashMap<HashedMissingArray, DenseMatrix64F>();
    private static final boolean STORE_VARIANCE = true;
    private static final boolean DEBUG = false;
    private boolean likelihoodKnown = false;
    private boolean storedLikelihoodKnow;
    private boolean statisticsKnown = false;
    private boolean storedStatisticsKnown;
    private boolean innerProductsKnown = false;
    private boolean storedInnerProductsKnown;
    private double logLikelihood;
    private double storedLogLikelihood;
    private double[] partials;
    private double[] storedPartials;
    private double[] normalizationConstants;
    private double[] storedNormalizationConstants;
    private double[] traitInnerProducts;
    private double[] storedTraitInnerProducts;
    private double[] data;
    private double[] loadings;
    private double[] gamma;
    private final int numTaxa;
    private final int dimTrait;
    private final int dimPartial;
    private final int numFactors;
    private final CompoundParameter traitParameter;
    private final MatrixParameterInterface loadingsTransposed;
    private final Parameter traitPrecision;
    private final List<Integer> missingFactorIndices;
    private final List<Integer> missingDataIndices;
    private final boolean[] missingDataIndicator;
    private final double[][] observedIndicators;
    private final int[] observedDimensions;
    private final boolean usePrecisionCache;
    private static double LOG_SQRT_2_PI = 0.5 * Math.log(Math.PI * 2);
    private ContinuousDataLikelihoodDelegate delegate = null;

    public IntegratedFactorAnalysisLikelihood(String string, CompoundParameter compoundParameter, boolean[] blArray, MatrixParameterInterface matrixParameterInterface, Parameter parameter, double d, TaskPool taskPool, CacheProvider cacheProvider) {
        super(string);
        int n;
        this.traitParameter = compoundParameter;
        this.loadingsTransposed = matrixParameterInterface;
        this.traitPrecision = parameter;
        this.numTaxa = compoundParameter.getParameterCount();
        this.dimTrait = compoundParameter.getParameter(0).getDimension();
        this.numFactors = matrixParameterInterface.getColumnDimension();
        assert (this.dimTrait == matrixParameterInterface.getRowDimension());
        this.dimPartial = precisionType.getPartialsDimension(this.numFactors);
        this.addVariable(compoundParameter);
        this.addVariable(matrixParameterInterface);
        this.addVariable(parameter);
        this.missingDataIndicator = blArray;
        this.missingDataIndices = ContinuousTraitPartialsProvider.indicatorToIndices(blArray);
        this.observedIndicators = IntegratedFactorAnalysisLikelihood.setupObservedIndicators(this.missingDataIndices, this.numTaxa, this.dimTrait);
        this.observedDimensions = IntegratedFactorAnalysisLikelihood.setupObservedDimensions(this.observedIndicators);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        this.setupObservedTraits(arrayList, arrayList2);
        this.fullyObservedTraits = new int[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            this.fullyObservedTraits[n] = (Integer)arrayList.get(n);
        }
        this.partiallyMissingTraits = new int[arrayList2.size()];
        for (n = 0; n < arrayList2.size(); ++n) {
            this.partiallyMissingTraits[n] = (Integer)arrayList2.get(n);
        }
        this.missingFactorIndices = new ArrayList<Integer>();
        for (n = 0; n < this.numTaxa * this.dimTrait; ++n) {
            this.missingFactorIndices.add(n);
        }
        this.nuggetPrecision = d;
        this.taskPool = taskPool != null ? taskPool : new TaskPool(this.numTaxa, 1);
        this.usePrecisionCache = cacheProvider.useCache();
        if (this.usePrecisionCache && this.taskPool.getNumThreads() > 1) {
            throw new IllegalArgumentException("Cannot currently parallelize cached precisions");
        }
        if (this.taskPool.getNumTaxon() != this.numTaxa) {
            throw new IllegalArgumentException("Incorrectly specified TaskPool");
        }
        this.observedInnerProduct = new DenseMatrix64F(this.numFactors, this.numFactors);
    }

    private final void setupObservedTraits(List<Integer> list, List<Integer> list2) {
        for (int i = 0; i < this.dimTrait; ++i) {
            int n = 0;
            for (int j = 0; j < this.numTaxa; ++j) {
                if (this.observedIndicators[j][i] != 1.0) continue;
                ++n;
            }
            if (n == this.numTaxa) {
                list.add(i);
                continue;
            }
            if (n <= 0) continue;
            list2.add(i);
        }
    }

    @Override
    public boolean bufferTips() {
        return true;
    }

    @Override
    public int getTraitCount() {
        return 1;
    }

    @Override
    public int getDataDimension() {
        return this.dimTrait;
    }

    @Override
    public int getTraitDimension() {
        return this.numFactors;
    }

    @Override
    public String getTipTraitName() {
        return this.tipTraitName;
    }

    @Override
    public void setTipTraitName(String string) {
        this.tipTraitName = string;
    }

    @Override
    public PrecisionType getPrecisionType() {
        return PrecisionType.FULL;
    }

    @Override
    public double[] getTipPartial(int n, boolean bl) {
        if (bl) {
            throw new IllegalArgumentException("Wishart statistics are not implemented for the integrated factor model");
        }
        this.checkStatistics();
        double[] dArray = new double[this.dimPartial];
        System.arraycopy(this.partials, n * this.dimPartial, dArray, 0, this.dimPartial);
        return dArray;
    }

    @Override
    public List<Integer> getMissingIndices() {
        return this.missingFactorIndices;
    }

    @Override
    public boolean[] getDataMissingIndicators() {
        return this.missingDataIndicator;
    }

    @Override
    public boolean[] getTraitMissingIndicators() {
        if (this.getDataMissingIndicators() == null) {
            return null;
        }
        if (this.missingTraitIndicators == null) {
            this.missingTraitIndicators = new boolean[this.getParameter().getDimension()];
            Arrays.fill(this.missingTraitIndicators, true);
        }
        return this.missingTraitIndicators;
    }

    public List<Integer> getMissingDataIndices() {
        return this.missingDataIndices;
    }

    @Override
    public CompoundParameter getParameter() {
        return this.traitParameter;
    }

    @Override
    public boolean usesMissingIndices() {
        return true;
    }

    @Override
    public ContinuousTraitPartialsProvider[] getChildModels() {
        return new ContinuousTraitPartialsProvider[0];
    }

    @Override
    public boolean getDefaultAllowSingular() {
        return true;
    }

    @Override
    public boolean suppliesWishartStatistics() {
        return false;
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        return 0.0;
    }

    @Override
    public void makeDirty() {
        this.likelihoodKnown = false;
        this.statisticsKnown = false;
        this.innerProductsKnown = false;
        this.observedInnerProductKnown = false;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.observedInnerProductKnown = false;
        if (variable == this.loadingsTransposed) {
            this.statisticsKnown = false;
            this.likelihoodKnown = false;
            this.fireModelChanged(this);
        } else if (variable == this.traitParameter || variable == this.traitPrecision) {
            this.innerProductsKnown = false;
            this.statisticsKnown = false;
            this.likelihoodKnown = false;
            this.fireModelChanged(this);
        } else {
            throw new RuntimeException("Unhandled parameter change type");
        }
    }

    @Override
    protected void storeState() {
        this.storedLogLikelihood = this.logLikelihood;
        this.storedLikelihoodKnow = this.likelihoodKnown;
        this.storedStatisticsKnown = this.statisticsKnown;
        System.arraycopy(this.partials, 0, this.storedPartials, 0, this.partials.length);
        System.arraycopy(this.normalizationConstants, 0, this.storedNormalizationConstants, 0, this.normalizationConstants.length);
        this.storedInnerProductsKnown = this.innerProductsKnown;
        System.arraycopy(this.traitInnerProducts, 0, this.storedTraitInnerProducts, 0, this.traitInnerProducts.length);
    }

    @Override
    protected void restoreState() {
        this.logLikelihood = this.storedLogLikelihood;
        this.likelihoodKnown = this.storedLikelihoodKnow;
        this.statisticsKnown = this.storedStatisticsKnown;
        double[] dArray = this.partials;
        this.partials = this.storedPartials;
        this.storedPartials = dArray;
        double[] dArray2 = this.normalizationConstants;
        this.normalizationConstants = this.storedNormalizationConstants;
        this.storedNormalizationConstants = dArray2;
        this.innerProductsKnown = this.storedInnerProductsKnown;
        double[] dArray3 = this.traitInnerProducts;
        this.traitInnerProducts = this.storedTraitInnerProducts;
        this.storedTraitInnerProducts = dArray3;
        this.observedInnerProductKnown = false;
    }

    @Override
    protected void acceptState() {
    }

    public int getNumberOfFactors() {
        return this.numFactors;
    }

    public int getNumberOfTaxa() {
        return this.numTaxa;
    }

    public int getNumberOfTraits() {
        return this.dimTrait;
    }

    public MatrixParameterInterface getLoadings() {
        return this.loadingsTransposed;
    }

    public Parameter getPrecision() {
        return this.traitPrecision;
    }

    private double calculateLogLikelihood() {
        this.checkStatistics();
        double d = 0.0;
        for (double d2 : this.normalizationConstants) {
            d += d2;
        }
        return d;
    }

    private void setupStatistics() {
        if (this.partials == null) {
            this.partials = new double[this.numTaxa * this.dimPartial];
            this.storedPartials = new double[this.numTaxa * this.dimPartial];
        }
        if (this.normalizationConstants == null) {
            this.normalizationConstants = new double[this.numTaxa];
            this.storedNormalizationConstants = new double[this.numTaxa];
        }
        if (this.traitInnerProducts == null) {
            this.traitInnerProducts = new double[this.numTaxa];
            this.storedTraitInnerProducts = new double[this.numTaxa];
        }
        if (!this.innerProductsKnown) {
            this.setupInnerProducts();
            this.innerProductsKnown = true;
        }
        this.loadings = this.loadingsTransposed.getParameterValues();
        this.gamma = this.traitPrecision.getParameterValues();
        this.computePartialsAndRemainders();
    }

    @Override
    public ContinuousExtensionDelegate getExtensionDelegate(ContinuousDataLikelihoodDelegate continuousDataLikelihoodDelegate, TreeTrait treeTrait, Tree tree) {
        return new ContinuousExtensionDelegate.IndependentNormalExtensionDelegate(continuousDataLikelihoodDelegate, treeTrait, this, tree);
    }

    @Override
    public boolean diagonalVariance() {
        return true;
    }

    @Override
    public DenseMatrix64F getExtensionVariance() {
        double[] dArray = this.traitPrecision.getParameterValues();
        DenseMatrix64F denseMatrix64F = MissingOps.wrapDiagonalInverse(dArray, 0, dArray.length);
        return denseMatrix64F;
    }

    @Override
    public DenseMatrix64F getExtensionVariance(NodeRef nodeRef) {
        return this.getExtensionVariance();
    }

    @Override
    public MatrixParameterInterface getExtensionPrecision() {
        return new DiagonalMatrix(this.traitPrecision);
    }

    @Override
    public double[] transformTreeTraits(double[] dArray) {
        DenseMatrix64F denseMatrix64F = DenseMatrix64F.wrap(this.numTaxa, this.numFactors, dArray);
        DenseMatrix64F denseMatrix64F2 = DenseMatrix64F.wrap(this.numFactors, this.dimTrait, this.loadingsTransposed.getParameterValues());
        DenseMatrix64F denseMatrix64F3 = new DenseMatrix64F(this.numTaxa, this.dimTrait);
        CommonOps.mult(denseMatrix64F, denseMatrix64F2, denseMatrix64F3);
        return denseMatrix64F3.data;
    }

    @Override
    public void chainRuleWrtVariance(double[] dArray, NodeRef nodeRef) {
        throw new RuntimeException("not yet implemented");
    }

    private void computePrecisionForTaxon(DenseMatrix64F denseMatrix64F, int n, int n2) {
        double[] dArray = this.observedIndicators[n];
        HashedMissingArray hashedMissingArray = null;
        D1Matrix64F d1Matrix64F = null;
        if (this.usePrecisionCache) {
            hashedMissingArray = new HashedMissingArray(dArray);
            d1Matrix64F = this.precisionMatrixMap.get(hashedMissingArray);
        }
        if (!this.usePrecisionCache || d1Matrix64F == null) {
            double d;
            int n3;
            int n4;
            if (!this.observedInnerProductKnown) {
                for (n4 = 0; n4 < n2; ++n4) {
                    for (n3 = n4; n3 < n2; ++n3) {
                        d = 0.0;
                        for (int n5 : this.fullyObservedTraits) {
                            d += this.loadings[n4 * this.dimTrait + n5] * this.gamma[n5] * this.loadings[n3 * this.dimTrait + n5];
                        }
                        this.observedInnerProduct.set(n4, n3, d);
                        this.observedInnerProduct.set(n3, n4, d);
                    }
                }
                this.observedInnerProductKnown = true;
            }
            for (n4 = 0; n4 < n2; ++n4) {
                for (n3 = n4; n3 < n2; ++n3) {
                    d = this.observedInnerProduct.get(n4, n3);
                    for (int n5 : this.partiallyMissingTraits) {
                        double d2 = dArray[n5] == 1.0 ? this.gamma[n5] : this.nuggetPrecision;
                        d += this.loadings[n4 * this.dimTrait + n5] * d2 * this.loadings[n3 * this.dimTrait + n5];
                    }
                    denseMatrix64F.unsafe_set(n4, n3, d);
                    denseMatrix64F.unsafe_set(n3, n4, d);
                }
            }
            if (this.usePrecisionCache) {
                this.precisionMatrixMap.put(hashedMissingArray, denseMatrix64F);
            }
        } else {
            System.arraycopy(d1Matrix64F.getData(), 0, denseMatrix64F.getData(), 0, n2 * n2);
        }
    }

    private void fillInMeanForTaxon(WrappedVector wrappedVector, DenseMatrix64F denseMatrix64F, int n) {
        double[] dArray = this.observedIndicators[n];
        double[] dArray2 = new double[this.numFactors];
        double[] dArray3 = new double[this.numFactors];
        for (int i = 0; i < this.numFactors; ++i) {
            double d = 0.0;
            for (int j = 0; j < this.dimTrait; ++j) {
                d += this.loadings[i * this.dimTrait + j] * dArray[j] * this.gamma[j] * this.data[n * this.dimTrait + j];
            }
            dArray2[i] = d;
        }
        DenseMatrix64F denseMatrix64F2 = DenseMatrix64F.wrap(this.numFactors, 1, dArray2);
        DenseMatrix64F denseMatrix64F3 = DenseMatrix64F.wrap(this.numFactors, 1, dArray3);
        MissingOps.safeSolve(denseMatrix64F, denseMatrix64F2, denseMatrix64F3, false);
        for (int i = 0; i < this.numFactors; ++i) {
            wrappedVector.set(i, denseMatrix64F3.unsafe_get(i, 0));
        }
    }

    private double computeTraitInnerProduct(int n) {
        double[] dArray = this.observedIndicators[n];
        Parameter parameter = this.traitParameter.getParameter(n);
        double d = 0.0;
        for (int i = 0; i < this.dimTrait; ++i) {
            d += parameter.getParameterValue(i) * parameter.getParameterValue(i) * dArray[i] * this.traitPrecision.getParameterValue(i);
        }
        return d;
    }

    private void cacheTraitInnerProducts(int n) {
        this.traitInnerProducts[n] = this.computeTraitInnerProduct(n);
    }

    private void setupInnerProducts() {
        this.data = this.traitParameter.getParameterValues();
        this.taskPool.fork((n, n2) -> this.cacheTraitInnerProducts(n));
    }

    private double computeFactorInnerProduct(WrappedVector wrappedVector, DenseMatrix64F denseMatrix64F) {
        double d = 0.0;
        for (int i = 0; i < this.numFactors; ++i) {
            for (int j = 0; j < this.numFactors; ++j) {
                d += wrappedVector.get(i) * denseMatrix64F.unsafe_get(i, j) * wrappedVector.get(j);
            }
        }
        return d;
    }

    private double getTraitLogDeterminant(int n) {
        double[] dArray = this.observedIndicators[n];
        double d = 0.0;
        for (int i = 0; i < this.dimTrait; ++i) {
            if (dArray[i] != 1.0) continue;
            d += Math.log(this.traitPrecision.getParameterValue(i));
        }
        return d;
    }

    private void makeCompletedUnobserved(DenseMatrix64F denseMatrix64F, double d) {
        for (int i = 0; i < this.numFactors; ++i) {
            for (int j = 0; j < this.numFactors; ++j) {
                double d2 = i == j ? d : 0.0;
                denseMatrix64F.unsafe_set(i, j, d2);
            }
        }
    }

    private void computePartialAndRemainderForOneTaxon(int n, DenseMatrix64F denseMatrix64F, DenseMatrix64F denseMatrix64F2) {
        double d;
        int n2 = this.dimPartial * n;
        WrappedVector.Raw raw = new WrappedVector.Raw(this.partials, n2, this.numFactors);
        this.computePrecisionForTaxon(denseMatrix64F, n, this.numFactors);
        this.fillInMeanForTaxon(raw, denseMatrix64F, n);
        double d2 = 0.0;
        int n3 = 0;
        double d3 = precisionType.getMissingDeterminantValue();
        if (this.observedDimensions[n] == 0) {
            this.makeCompletedUnobserved(denseMatrix64F, 0.0);
            this.makeCompletedUnobserved(denseMatrix64F2, Double.POSITIVE_INFINITY);
            d = 0.0;
        } else {
            InversionResult inversionResult = MissingOps.safeDeterminant(denseMatrix64F, false);
            n3 = inversionResult.getEffectiveDimension();
            d3 = inversionResult.getReturnCode() == InversionResult.Code.NOT_OBSERVED ? 0.0 : inversionResult.getLogDeterminant();
            double d4 = this.getTraitLogDeterminant(n);
            double d5 = this.computeFactorInnerProduct(raw, denseMatrix64F);
            double d6 = this.traitInnerProducts[n];
            double d7 = d6 - d5;
            d = 0.5 * (d4 - d3 - d7) - LOG_SQRT_2_PI * (double)(this.observedDimensions[n] - n3) - d2;
        }
        MissingOps.unwrap(denseMatrix64F, this.partials, n2 + this.numFactors);
        precisionType.fillEffDimInPartials(this.partials, n2, n3, this.numFactors);
        precisionType.fillDeterminantInPartials(this.partials, n2, d3, this.numFactors);
        precisionType.fillRemainderInPartials(this.partials, n2, d, this.numFactors);
        MissingOps.safeInvert2(denseMatrix64F, denseMatrix64F2, true);
        MissingOps.unwrap(denseMatrix64F2, this.partials, n2 + this.numFactors + this.numFactors * this.numFactors);
        this.normalizationConstants[n] = d;
    }

    private void computePartialsAndRemainders() {
        DenseMatrix64F[] denseMatrix64FArray = new DenseMatrix64F[this.taskPool.getNumThreads()];
        DenseMatrix64F[] denseMatrix64FArray2 = new DenseMatrix64F[this.taskPool.getNumThreads()];
        for (int i = 0; i < this.taskPool.getNumThreads(); ++i) {
            denseMatrix64FArray[i] = new DenseMatrix64F(this.numFactors, this.numFactors);
            denseMatrix64FArray2[i] = new DenseMatrix64F(this.numFactors, this.numFactors);
        }
        if (this.usePrecisionCache) {
            this.precisionMatrixMap.clear();
        }
        this.taskPool.fork((n, n2) -> this.computePartialAndRemainderForOneTaxon(n, denseMatrix64FArray[n2], denseMatrix64FArray2[n2]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStatistics() {
        IntegratedFactorAnalysisLikelihood integratedFactorAnalysisLikelihood = this;
        synchronized (integratedFactorAnalysisLikelihood) {
            if (!this.statisticsKnown) {
                this.setupStatistics();
                this.statisticsKnown = true;
            }
        }
    }

    private static double[][] setupObservedIndicators(List<Integer> list, int n, int n2) {
        double[][] dArray = new double[n][n2];
        for (double[] dArray2 : dArray) {
            Arrays.fill(dArray2, 1.0);
        }
        if (list != null) {
            Object object = list.iterator();
            while (object.hasNext()) {
                Integer n3 = (Integer)object.next();
                int n4 = n3 / n2;
                int n5 = n3 % n2;
                dArray[n4][n5] = 0.0;
            }
        }
        return dArray;
    }

    private static int[] setupObservedDimensions(double[][] dArray) {
        int n = dArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            double d = 0.0;
            for (double d2 : dArray[i]) {
                d += d2;
            }
            nArray[i] = (int)d;
        }
        return nArray;
    }

    public void setLikelihoodDelegate(ContinuousDataLikelihoodDelegate continuousDataLikelihoodDelegate) {
        this.delegate = continuousDataLikelihoodDelegate;
    }

    private static Matrix buildDiagonalMatrix(double[] dArray) {
        Matrix matrix = new Matrix(dArray.length, dArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            matrix.set(i, i, dArray[i]);
        }
        return matrix;
    }

    @Override
    public String getReport() {
        StringBuilder stringBuilder = new StringBuilder();
        double d = 0.0;
        if (this.delegate != null) {
            Object object;
            double d2 = this.delegate.getCallbackLikelihood().getLogLikelihood();
            Tree tree = this.delegate.getCallbackLikelihood().getTree();
            BranchRateModel branchRateModel = this.delegate.getCallbackLikelihood().getBranchRateModel();
            stringBuilder.append(tree.toString());
            stringBuilder.append("\n\n");
            double d3 = this.delegate.getRateTransformation().getNormalization();
            double d4 = this.delegate.getRootProcessDelegate().getPseudoObservations();
            double[][] dArray = MultivariateTraitDebugUtilities.getTreeVariance(tree, branchRateModel, 1.0, Double.POSITIVE_INFINITY);
            stringBuilder.append("Tree structure:\n");
            stringBuilder.append(new Matrix(dArray));
            stringBuilder.append("\n\n");
            double[][] dArray2 = MultivariateTraitDebugUtilities.getTreeVariance(tree, branchRateModel, d3, Double.POSITIVE_INFINITY);
            double[][] dArray3 = MultivariateTraitDebugUtilities.getTreeVariance(tree, branchRateModel, d3, d4);
            Matrix matrix = new Matrix(dArray3);
            Matrix matrix2 = matrix.inverse();
            stringBuilder.append("Tree variance:\n");
            stringBuilder.append(matrix);
            stringBuilder.append("Tree precision:\n");
            stringBuilder.append(matrix2);
            stringBuilder.append("\n\n");
            Matrix matrix3 = new Matrix(this.loadingsTransposed.getParameterAsMatrix());
            stringBuilder.append("Loadings:\n");
            stringBuilder.append(matrix3.transpose());
            stringBuilder.append("\n\n");
            double[][] dArray4 = this.delegate.getDiffusionModel().getPrecisionmatrix();
            Matrix matrix4 = new Matrix(dArray4).inverse();
            Matrix matrix5 = null;
            try {
                matrix5 = matrix3.product(matrix4.product(matrix3.transpose()));
            }
            catch (IllegalDimension illegalDimension) {
                illegalDimension.printStackTrace();
            }
            stringBuilder.append("Loadings variance:\n");
            stringBuilder.append(matrix5);
            stringBuilder.append("\n\n");
            assert (matrix5 != null);
            Matrix matrix6 = MultivariateTraitDebugUtilities.getJointVarianceFactor(d4, dArray3, dArray2, matrix5.toComponents(), matrix4.toComponents(), this.delegate.getDiffusionProcessDelegate(), matrix3);
            Matrix matrix7 = IntegratedFactorAnalysisLikelihood.buildDiagonalMatrix(this.traitPrecision.getParameterValues());
            stringBuilder.append("Trait precision:\n");
            stringBuilder.append(matrix7);
            stringBuilder.append("\n\n");
            Matrix matrix8 = matrix7.inverse();
            double[] dArray5 = new double[tree.getExternalNodeCount()];
            Arrays.fill(dArray5, 1.0);
            Matrix matrix9 = IntegratedFactorAnalysisLikelihood.buildDiagonalMatrix(dArray5);
            Matrix matrix10 = new Matrix(KroneckerOperation.product(matrix9.toComponents(), matrix8.toComponents()));
            stringBuilder.append("Loadings-factors variance:\n");
            stringBuilder.append(matrix6);
            stringBuilder.append("\n\n");
            stringBuilder.append("Error variance\n");
            stringBuilder.append(matrix10);
            stringBuilder.append("\n\n");
            Matrix matrix11 = null;
            try {
                matrix11 = matrix6.add(matrix10);
            }
            catch (IllegalDimension illegalDimension) {
                illegalDimension.printStackTrace();
            }
            double[] dArray6 = this.getParameter().getParameterValues();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < this.numTaxa; ++i) {
                object = this.observedIndicators[i];
                for (int j = 0; j < this.dimTrait; ++j) {
                    if (object[j] == 0.0) {
                        System.err.println("Missing taxon " + i + " trait " + j);
                        continue;
                    }
                    arrayList.add(i * this.dimTrait + j);
                }
            }
            double[] dArray7 = this.delegate.getRootPrior().getMean();
            object = new Matrix(MultivariateTraitDebugUtilities.getTreeDrift(tree, dArray7, this.delegate.getIntegrator(), this.delegate.getDiffusionProcessDelegate()));
            if (this.delegate.getDiffusionProcessDelegate().hasDrift()) {
                stringBuilder.append("Tree drift (including root mean):\n");
                stringBuilder.append(new Matrix(((Matrix)object).toComponents()));
                stringBuilder.append("\n\n");
            }
            try {
                matrix6 = ((Matrix)object).product(matrix3.transpose());
            }
            catch (IllegalDimension illegalDimension) {
                illegalDimension.printStackTrace();
            }
            double[] dArray8 = KroneckerOperation.vectorize(matrix6.toComponents());
            int[] nArray = new int[arrayList.size()];
            double[] dArray9 = new double[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                nArray[i] = (Integer)arrayList.get(i);
                dArray9[i] = dArray6[(Integer)arrayList.get(i)];
            }
            if (matrix11 != null) {
                matrix11 = new Matrix(Matrix.gatherRowsAndColumns(matrix11.toComponents(), nArray, nArray));
            }
            Matrix matrix12 = null;
            if (matrix11 != null) {
                matrix12 = matrix11.inverse();
            }
            dArray8 = Matrix.gatherEntries(dArray8, nArray);
            stringBuilder.append("Total variance:\n");
            stringBuilder.append(matrix11);
            stringBuilder.append("\n\n");
            stringBuilder.append("Total precision:\n");
            stringBuilder.append(matrix12);
            stringBuilder.append("\n\n");
            stringBuilder.append("Data:\n");
            stringBuilder.append(new Vector(dArray9));
            stringBuilder.append("\n\n");
            stringBuilder.append("Expectations:\n");
            stringBuilder.append(new Vector(dArray8));
            stringBuilder.append("\n\n");
            MultivariateNormalDistribution multivariateNormalDistribution = null;
            if (matrix12 != null) {
                multivariateNormalDistribution = new MultivariateNormalDistribution(dArray8, matrix12.toComponents());
            }
            double d5 = 0.0;
            if (multivariateNormalDistribution != null) {
                d5 = multivariateNormalDistribution.logPdf(dArray9);
            }
            stringBuilder.append("logMultiVariateNormalDensity = ").append(d5).append("\n\n");
            stringBuilder.append("traitDataLikelihood = ").append(d2).append("\n");
            d += d2;
        }
        stringBuilder.append("logLikelihood = ").append(this.getLogLikelihood()).append("\n");
        if (d != 0.0) {
            stringBuilder.append("total likelihood = ").append(this.getLogLikelihood() + d).append("\n");
        }
        return stringBuilder.toString();
    }

    public static enum CacheProvider {
        USE_CACHE{

            @Override
            boolean useCache() {
                return true;
            }
        }
        ,
        NO_CACHE{

            @Override
            boolean useCache() {
                return false;
            }
        };


        abstract boolean useCache();
    }
}

