/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.mcmc;

import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.loggers.Logger;
import dr.inference.markovchain.MarkovChain;
import dr.inference.markovchain.MarkovChainListener;
import dr.inference.mcmc.MCMCCriterion;
import dr.inference.mcmc.MCMCOptions;
import dr.inference.model.Likelihood;
import dr.inference.model.Model;
import dr.inference.operators.AdaptableMCMCOperator;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.OperatorAnalysisPrinter;
import dr.inference.operators.OperatorSchedule;
import dr.inference.operators.SimpleOperatorSchedule;
import dr.inference.state.Factory;
import dr.inference.state.StateLoader;
import dr.util.Identifiable;
import dr.util.NumberFormatter;
import dr.util.Timer;
import dr.xml.Spawnable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class MCMC
implements Identifiable,
Spawnable,
Loggable {
    private final MarkovChainListener chainListener = new MarkovChainListener(){

        @Override
        public void currentState(long l, MarkovChain markovChain, Model model) {
            MCMC.this.currentState = l;
            if (MCMC.this.loggers != null) {
                for (Logger logger : MCMC.this.loggers) {
                    logger.log(l);
                }
            }
        }

        @Override
        public void bestState(long l, MarkovChain markovChain, Model model) {
        }

        @Override
        public void finished(long l, MarkovChain markovChain) {
            MCMC.this.currentState = l;
            if (MCMC.this.loggers != null) {
                for (Logger logger : MCMC.this.loggers) {
                    logger.log(MCMC.this.currentState);
                    logger.stopLogging();
                }
            }
            if (MCMC.this.showOperatorAnalysis) {
                OperatorAnalysisPrinter.showOperatorAnalysis(System.out, MCMC.this.getOperatorSchedule(), MCMC.this.options.useAdaptation());
            }
            if (MCMC.this.operatorAnalysisFile != null) {
                try {
                    PrintStream printStream = new PrintStream(new FileOutputStream(MCMC.this.operatorAnalysisFile));
                    OperatorAnalysisPrinter.showOperatorAnalysis(printStream, MCMC.this.getOperatorSchedule(), MCMC.this.options.useAdaptation());
                    printStream.flush();
                    printStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    };
    private boolean spawnable = true;
    protected final boolean isAdapting = true;
    protected boolean stopping = false;
    protected boolean showOperatorAnalysis = Boolean.parseBoolean(System.getProperty("show_operators"));
    protected File operatorAnalysisFile = null;
    protected final Timer timer = new Timer();
    protected long currentState = 0L;
    protected final NumberFormatter formatter = new NumberFormatter(8);
    protected MarkovChain mc;
    protected MCMCOptions options;
    protected Logger[] loggers;
    protected OperatorSchedule schedule;
    private String id = null;

    public MCMC(String string) {
        this.id = string;
    }

    public void init(MCMCOptions mCMCOptions, Likelihood likelihood, OperatorSchedule operatorSchedule, Logger[] loggerArray) {
        MCMCCriterion mCMCCriterion = new MCMCCriterion();
        mCMCCriterion.setTemperature(mCMCOptions.getTemperature());
        this.mc = new MarkovChain(likelihood, operatorSchedule, mCMCCriterion, mCMCOptions.getFullEvaluationCount(), mCMCOptions.minOperatorCountForFullEvaluation(), mCMCOptions.getEvaluationTestThreshold(), mCMCOptions.useAdaptation(), mCMCOptions.useSmoothedAcceptanceProbability());
        this.options = mCMCOptions;
        this.loggers = loggerArray;
        this.schedule = operatorSchedule;
        this.currentState = 0L;
        if (Factory.INSTANCE != null) {
            for (MarkovChainListener markovChainListener : Factory.INSTANCE.getStateSaverChainListeners()) {
                this.mc.addMarkovChainListener(markovChainListener);
            }
        }
    }

    public void init(long l, Likelihood likelihood, MCMCOperator[] mCMCOperatorArray, Logger[] loggerArray) {
        MCMCOptions mCMCOptions = new MCMCOptions(l);
        MCMCCriterion mCMCCriterion = new MCMCCriterion();
        mCMCCriterion.setTemperature(1.0);
        SimpleOperatorSchedule simpleOperatorSchedule = new SimpleOperatorSchedule();
        for (MCMCOperator mCMCOperator : mCMCOperatorArray) {
            simpleOperatorSchedule.addOperator(mCMCOperator);
        }
        this.init(mCMCOptions, likelihood, simpleOperatorSchedule, loggerArray);
    }

    public MarkovChain getMarkovChain() {
        return this.mc;
    }

    public Logger[] getLoggers() {
        return this.loggers;
    }

    public MCMCOptions getOptions() {
        return this.options;
    }

    public OperatorSchedule getOperatorSchedule() {
        return this.schedule;
    }

    @Override
    public void run() {
        this.chain();
    }

    public void chain() {
        this.stopping = false;
        this.currentState = 0L;
        this.timer.start();
        if (this.loggers != null) {
            for (Logger object : this.loggers) {
                object.startLogging();
            }
        }
        if (!this.stopping) {
            StateLoader stateLoader;
            long l = 0L;
            if (Factory.INSTANCE != null && (stateLoader = Factory.INSTANCE.getInitialStateLoader()) != null) {
                double[] dArray = new double[1];
                l = stateLoader.loadState(this.mc, dArray);
                this.mc.setCurrentLength(l);
                double d = this.mc.evaluate();
                stateLoader.checkLoadState(dArray[0], d);
            }
            this.mc.addMarkovChainListener(this.chainListener);
            long l2 = this.getChainLength();
            long l3 = this.getAdaptationDelay();
            if (l3 > l) {
                this.mc.runChain(l3 - l, true);
                l2 -= l3;
                for (int i = 0; i < this.schedule.getOperatorCount(); ++i) {
                    this.schedule.getOperator(i).reset();
                }
            }
            this.mc.runChain(l2, false);
            this.mc.terminateChain();
            this.mc.removeMarkovChainListener(this.chainListener);
        }
        this.timer.stop();
    }

    @Override
    public LogColumn[] getColumns() {
        return new LogColumn[]{new LogColumn(){

            @Override
            public void setLabel(String string) {
            }

            @Override
            public String getLabel() {
                return "time";
            }

            @Override
            public void setMinimumWidth(int n) {
            }

            @Override
            public int getMinimumWidth() {
                return 0;
            }

            @Override
            public String getFormatted() {
                return Double.toString(MCMC.this.getTimer().toSeconds());
            }
        }};
    }

    public Likelihood getLikelihood() {
        return this.mc.getLikelihood();
    }

    public Timer getTimer() {
        return this.timer;
    }

    public final long getChainLength() {
        return this.options.getChainLength();
    }

    public final long getCurrentState() {
        return this.currentState;
    }

    public final double getProgress() {
        return (double)this.currentState / (double)this.options.getChainLength();
    }

    public final boolean isAdapting() {
        return true;
    }

    public void pleaseStop() {
        this.stopping = true;
        this.mc.pleaseStop();
    }

    public boolean isStopped() {
        return this.mc.isStopped();
    }

    @Override
    public boolean getSpawnable() {
        return this.spawnable;
    }

    public void setSpawnable(boolean bl) {
        this.spawnable = bl;
    }

    protected long getAdaptationDelay() {
        long l = this.options.getAdaptationDelay();
        if (l < 0L) {
            l = this.options.getChainLength() / 100L;
        }
        if (this.options.useAdaptation()) {
            return l;
        }
        for (int i = 0; i < this.schedule.getOperatorCount(); ++i) {
            MCMCOperator mCMCOperator = this.schedule.getOperator(i);
            if (!(mCMCOperator instanceof AdaptableMCMCOperator) || ((AdaptableMCMCOperator)mCMCOperator).getMode() != AdaptationMode.ADAPTATION_ON) continue;
            return l;
        }
        return -1L;
    }

    public void setShowOperatorAnalysis(boolean bl) {
        this.showOperatorAnalysis = bl;
    }

    public void setOperatorAnalysisFile(File file) {
        this.operatorAnalysisFile = file;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }
}

