/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.factorAnalysis;

import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.continuous.IntegratedFactorAnalysisLikelihood;
import dr.geo.distributions.MatrixVonMisesFisherDistribution;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.inference.operators.factorAnalysis.FactorAnalysisOperatorAdaptor;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import org.ejml.data.DenseMatrix64F;

public class MatrixVonMisesFisherGibbsOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    private static final String MATRIX_VONMISES_FISHER_GIBBS = "matrixVonMisesFisherGibbsOperator";
    private final FactorAnalysisOperatorAdaptor adaptor;
    private final DenseMatrix64F C;
    private final MatrixVonMisesFisherDistribution vonMisesFisherDistribution;
    public static final AbstractXMLObjectParser PARSER = new AbstractXMLObjectParser(){

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            TreeDataLikelihood treeDataLikelihood = (TreeDataLikelihood)xMLObject.getChild(TreeDataLikelihood.class);
            IntegratedFactorAnalysisLikelihood integratedFactorAnalysisLikelihood = (IntegratedFactorAnalysisLikelihood)xMLObject.getChild(IntegratedFactorAnalysisLikelihood.class);
            FactorAnalysisOperatorAdaptor.IntegratedFactors integratedFactors = new FactorAnalysisOperatorAdaptor.IntegratedFactors(integratedFactorAnalysisLikelihood, treeDataLikelihood);
            double d = xMLObject.getDoubleAttribute("weight");
            return new MatrixVonMisesFisherGibbsOperator(d, integratedFactors);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{new ElementRule(TreeDataLikelihood.class), new ElementRule(IntegratedFactorAnalysisLikelihood.class), AttributeRule.newDoubleRule("weight")};
        }

        @Override
        public String getParserDescription() {
            return null;
        }

        @Override
        public Class getReturnType() {
            return MatrixVonMisesFisherGibbsOperator.class;
        }

        @Override
        public String getParserName() {
            return MatrixVonMisesFisherGibbsOperator.MATRIX_VONMISES_FISHER_GIBBS;
        }
    };

    MatrixVonMisesFisherGibbsOperator(double d, FactorAnalysisOperatorAdaptor factorAnalysisOperatorAdaptor) {
        this.setWeight(d);
        this.adaptor = factorAnalysisOperatorAdaptor;
        this.C = new DenseMatrix64F(factorAnalysisOperatorAdaptor.getNumberOfTraits(), factorAnalysisOperatorAdaptor.getNumberOfFactors());
        this.vonMisesFisherDistribution = new MatrixVonMisesFisherDistribution(factorAnalysisOperatorAdaptor);
    }

    @Override
    public String getOperatorName() {
        return MATRIX_VONMISES_FISHER_GIBBS;
    }

    @Override
    public double doOperation() {
        double[] dArray = this.vonMisesFisherDistribution.nextRandom();
        double[] dArray2 = new double[this.adaptor.getNumberOfFactors()];
        for (int i = 0; i < this.adaptor.getNumberOfTraits(); ++i) {
            int n = i;
            for (int j = 0; j < this.adaptor.getNumberOfFactors(); ++j) {
                dArray2[j] = dArray[n];
                n += this.adaptor.getNumberOfTraits();
            }
            this.adaptor.setLoadingsForTraitQuietly(i, dArray2);
        }
        this.adaptor.fireLoadingsChanged();
        return 0.0;
    }
}

