/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.hmc;

import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.hmc.HessianWrtParameterProvider;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.math.matrixAlgebra.ReadableVector;
import dr.math.matrixAlgebra.WrappedVector;

class SecantHessian
implements HessianWrtParameterProvider {
    private final int dim;
    private final GradientWrtParameterProvider gradientProvider;
    private final int secantSize;
    private final Secant[] queue;
    private int secantIndex;
    private int secantUpdateCount;
    private double[][] secantHessian;

    SecantHessian(GradientWrtParameterProvider gradientWrtParameterProvider, int n) {
        this.gradientProvider = gradientWrtParameterProvider;
        this.secantSize = n;
        this.dim = gradientWrtParameterProvider.getDimension();
        this.secantHessian = new double[this.dim][this.dim];
        for (int i = 0; i < this.dim; ++i) {
            this.secantHessian[i][i] = 1.0;
        }
        this.queue = new Secant[n];
        this.secantIndex = 0;
        this.secantUpdateCount = 0;
    }

    @Override
    public double[] getDiagonalHessianLogDensity() {
        double[] dArray = new double[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            dArray[i] = this.secantHessian[i][i];
        }
        return dArray;
    }

    @Override
    public double[][] getHessianLogDensity() {
        return (double[][])this.secantHessian.clone();
    }

    @Override
    public Likelihood getLikelihood() {
        return this.gradientProvider.getLikelihood();
    }

    @Override
    public Parameter getParameter() {
        return this.gradientProvider.getParameter();
    }

    @Override
    public int getDimension() {
        return this.gradientProvider.getDimension();
    }

    @Override
    public double[] getGradientLogDensity() {
        return this.gradientProvider.getGradientLogDensity();
    }

    public void storeSecant(ReadableVector readableVector, ReadableVector readableVector2) {
        this.queue[this.secantIndex] = new Secant(readableVector, readableVector2);
        if (this.secantUpdateCount == 0) {
            this.initializeSecantHessian(this.queue[this.secantIndex]);
        } else {
            int n = (this.secantIndex + this.secantSize - 1) % this.queue.length;
            this.updateSecantHessian(this.queue[this.secantIndex], this.queue[n]);
        }
        this.secantIndex = (this.secantIndex + 1) % this.queue.length;
        ++this.secantUpdateCount;
    }

    private void initializeSecantHessian(Secant secant) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.dim; ++i) {
            d += secant.getGradient(i) * secant.getPosition(i);
            d2 += secant.getGradient(i) * secant.getGradient(i);
        }
        double d3 = d2 == 0.0 ? 1.0 : d / d2;
        for (int i = 0; i < this.dim; ++i) {
            this.secantHessian[i][i] = d3;
        }
    }

    private void updateSecantHessian(Secant secant, Secant secant2) {
        int n;
        double[] dArray = new double[this.dim];
        double d = 0.0;
        secant.updateSkYk(secant2);
        double d2 = secant.getReciprocalInnerProduct();
        for (n = 0; n < this.dim; ++n) {
            double d3 = 0.0;
            for (int i = 0; i < this.dim; ++i) {
                d3 += this.secantHessian[n][i] * secant.getSk(i);
            }
            dArray[n] = d3;
            d += secant.getSk(n) * dArray[n];
        }
        d = -1.0 / d;
        for (n = 0; n < this.dim; ++n) {
            for (int i = 0; i < this.dim; ++i) {
                double[] dArray2 = this.secantHessian[n];
                int n2 = i;
                dArray2[n2] = dArray2[n2] + (d2 * secant.getYk(n) * secant.getYk(i) + d * dArray[n] * dArray[i]);
            }
        }
    }

    private class Secant {
        ReadableVector gradient;
        ReadableVector position;
        WrappedVector sk;
        WrappedVector yk;
        private double reciprocalInnerProduct;

        Secant(ReadableVector readableVector, ReadableVector readableVector2) {
            this.gradient = WrappedVector.Utils.copy(readableVector);
            this.position = WrappedVector.Utils.copy(readableVector2);
            this.sk = new WrappedVector.Raw(new double[readableVector2.getDim()]);
            this.yk = new WrappedVector.Raw(new double[readableVector2.getDim()]);
            this.reciprocalInnerProduct = 0.0;
        }

        double getPosition(int n) {
            return this.position.get(n);
        }

        double getGradient(int n) {
            return this.gradient.get(n);
        }

        void updateSkYk(Secant secant) {
            this.reciprocalInnerProduct = 0.0;
            for (int i = 0; i < SecantHessian.this.dim; ++i) {
                double d = secant.getPosition(i) - this.getPosition(i);
                double d2 = secant.getGradient(i) - this.getGradient(i);
                this.sk.set(i, d);
                this.yk.set(i, d2);
                this.reciprocalInnerProduct += this.sk.get(i) * this.yk.get(i);
            }
            this.reciprocalInnerProduct = 1.0 / this.reciprocalInnerProduct;
        }

        double getReciprocalInnerProduct() {
            return this.reciprocalInnerProduct;
        }

        double getYk(int n) {
            return this.yk.get(n);
        }

        double getSk(int n) {
            return this.sk.get(n);
        }
    }
}

