% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflowfunction.R
\name{ColInfo}
\alias{ColInfo}
\title{Column Info of Biclusters}
\usage{
ColInfo(result, matrix, plots = c(1, 2), plot.type = "device",
  filename = "ColInfo")
}
\arguments{
\item{result}{A Biclust Object.}

\item{matrix}{Accompanying data matrix which was used to obtain \code{result}.}

\item{plots}{Which plots to draw:
\enumerate{
\item Barplot of number of appearances of column labels in bicluster results.
\item Biclustmember plot of BC results (see \code{\link[biclust]{biclustmember}}).
}}

\item{plot.type}{Output Type
\itemize{
\item \code{"device"}: All plots are outputted to new R graphics devices (default).
\item \code{"file"}: All plots are saved in external files. Plots are joint together in a single \code{.pdf} file.
\item \code{"other"}: All plots are outputted to the current graphics device, but will overwrite each other. Use this if you want to include one or more plots in a sweave/knitr file or if you want to export a single plot by your own chosen format.
}}

\item{filename}{Base filename (with/without directory) for the plots if \code{plot.type="file"} (default=\code{"RowCoverage"}).}
}
\value{
A list object (length equal to number of Biclusters) in which vectors of column labels are saved.
}
\description{
Function that returns which column labels are part of the pattern derived from the biclusters.
Additionally, a biclustmember plot and a general barplot of the column labels (retrieved from the biclusters) can be drawn.
}
\examples{
\dontrun{
data <- matrix(sample(c(0,1),100*100,replace=TRUE,prob=c(0.9,0.1)),nrow=100,ncol=100)
data[1:10,1:10] <- 1 # BC1
data[11:20,11:20] <- 1 # BC2
data[21:30,21:30] <- 1 # BC3
data <- data[sample(1:nrow(data),nrow(data)),sample(1:ncol(data),ncol(data))]
result <- bibit(data,minr=5,minc=5)
ColInfo(result=result,matrix=data)
}
}
\author{
Ewoud De Troyer
}

