% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{get_subgroup_results}
\alias{get_subgroup_results}
\title{Get Subgroup Results}
\usage{
get_subgroup_results(model, X_feature, subgroup_label = NULL, cutoff = 0.5)
}
\arguments{
\item{model}{The trained XGBoost-based subgroup model.}

\item{X_feature}{The data matrix containing patient features.}

\item{subgroup_label}{(Optional) The subgroup labels. In real-world data, this information is typically unknown and only available in simulated data. If provided, the prediction accuracy will also be returned.}

\item{cutoff}{The cutoff value for treatment assignment, defaulted to 0.5.}
}
\value{
A data frame containing each subject and assigned treatment (1 for treatment, 0 for control). If subgroup labels are provided, it also returns the prediction accuracy of the subgroup labels.
}
\description{
This function predicts the treatment assignment for each patient based on a cutoff value.
}
\examples{
X_data <- matrix(rnorm(100 * 10), ncol = 10)  # 100 samples with 10 features
y_data <- rnorm(100)  # continuous outcome variable
trt <- sample(c(1, -1), 100, replace = TRUE)  # treatment indicator (1 or -1)
pi <- runif(100, min = 0.3, max = 0.7)  # propensity scores between 0 and 1

# Define XGBoost parameters
params <- list(
  max_depth = 3,
  eta = 0.1,
  subsample = 0.8,
  colsample_bytree = 0.8
)

# Train the model using A-learning loss
model_A <- XGBoostSub_con(
  X_data = X_data,
  y_data = y_data,
  trt = trt,
  pi = pi,
  Loss_type = "A_learning",
  params = params,
  nrounds = 5,
  disable_default_eval_metric = 1,
  verbose = TRUE
)
subgroup_results=get_subgroup_results(model_A, X_data, subgroup_label=NULL, cutoff = 0.5)
}
