% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{subgrp_perf}
\alias{subgrp_perf}
\title{Subgroup Performance Evaluation for Prognostic Cases}
\usage{
subgrp_perf(
  yvar,
  censorvar = NULL,
  grpvar,
  grpname,
  xvars.adj = NULL,
  data,
  type,
  yvar.display = yvar,
  grpvar.display = grpvar
)
}
\arguments{
\item{yvar}{The response variable name.}

\item{censorvar}{(Optional) The censoring variable name (0-censored, 1-event).}

\item{grpvar}{The subgroup variable name.}

\item{grpname}{A vector of ordered subgroup names (values in the column of grpvar).}

\item{xvars.adj}{(Optional) Other covariates to adjust when evaluating the performance.}

\item{data}{The dataset containing the variables.}

\item{type}{The type of response variable: "c" for continuous, "s" for survival, and "b" for binary.}

\item{yvar.display}{Display name of the response variable.}

\item{grpvar.display}{Display name of the group variable.}
}
\value{
A list containing subgroup performance results including logrank p-value, median and mean survival, Cox model p-value, ANOVA p-value, and more based on the specified response variable type.
}
\description{
This function evaluates subgroup performance based on different types of response variables.
}
\examples{
# Load a sample dataset
data <- data.frame(
  survival_time = rexp(100, rate = 0.1),  # survival time
  status = sample(c(0, 1), 100, replace = TRUE),  # censoring status
  group = sample(c("Low", "Medium", "High"), 100, replace = TRUE),  # subgroup variable
  covariate = rnorm(100, mean = 50, sd = 10)  # an additional covariate
)

# Perform subgroup performance evaluation for survival analysis
subgrp_perf(
  yvar = "survival_time",
  censorvar = "status",
  grpvar = "group",
  grpname = c("Low", "Medium", "High"),
  data = data,
  type = "s",
  yvar.display = "Survival Time",
  grpvar.display = "Risk Group"
)

# Perform subgroup performance evaluation for continuous outcome
data$continuous_outcome <- rnorm(100, mean = 10, sd = 5)
subgrp_perf(
  yvar = "continuous_outcome",
  grpvar = "group",
  grpname = c("Low", "Medium", "High"),
  data = data,
  type = "c",
  yvar.display = "Continuous Outcome",
  grpvar.display = "Risk Group"
)

# Perform subgroup performance evaluation for binary outcome
data$binary_outcome <- sample(c(0, 1), 100, replace = TRUE)
subgrp_perf(
  yvar = "binary_outcome",
  grpvar = "group",
  grpname = c("Low", "Medium", "High"),
  data = data,
  type = "b",
  yvar.display = "Binary Outcome",
  grpvar.display = "Risk Group"
)
}
