% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BP_SummaryBone.R
\name{summary.BoneProfileR}
\alias{summary.BoneProfileR}
\title{Plot a bone section}
\usage{
\method{summary}{BoneProfileR}(
  object,
  analysis = 1,
  periodic.angles = "all",
  periodic.angles.replicate.CI = 2000,
  ...
)
}
\arguments{
\item{object}{The bone image}

\item{analysis}{The analysis to report the compactness}

\item{periodic.angles}{A vector indicating which angle to report for periodic analysis}

\item{periodic.angles.replicate.CI}{Number of replicates to estimate CI}

\item{...}{Not used}
}
\value{
An invisible list with recorded information
}
\description{
Display information of bone section
}
\details{
summary.BoneProfileR displays a bone section
}
\examples{
\dontrun{
# Not run:
library(BoneProfileR)
 bone <- BP_OpenImage()
 # or 
 path_Hedgehog <- system.file("extdata", "Erinaceus_europaeus_fem_2-1_small.png", 
                             package = "BoneProfileR")
 bone <- BP_OpenImage(file=path_Hedgehog)
 summary(bone)
 
 bone <- BP_DetectBackground(bone=bone, analysis="logistic")
 bone <- BP_DetectForeground(bone=bone, analysis="logistic")
 bone <- BP_DetectCenters(bone=bone, analysis="logistic")
 bone <- BP_EstimateCompactness(bone, analysis="logistic", cut.angle = 60)
 bone <- BP_FitMLCompactness(bone, analysis="logistic", twosteps=TRUE)
 plot(bone, type="observations+model", analysis="logistic")
 par <- BP_GetFittedParameters(bone, analysis="logistic", ML=TRUE, return.all=FALSE)[, "mean"]
 options(mc.cores=parallel::detectCores())
 
 #############################################
 # Periodic analysis
 #############################################
 bone <- BP_FitMLPeriodicCompactness(bone, analysis="logistic", control.optim=list(trace=2), 
                                     fitted.parameters=c(par, PSin=0.001, PCos=0.001, 
                                     SSin=0.001, SCos=0.001, MinSin=0.001, MinCos=0.001, 
                                     MaxSin=0.001, MaxCos=0.001), replicates.CI=2000)
 bone <- BP_FitBayesianPeriodicCompactness(bone, analysis="logistic", replicates.CI=2000)
 
 summary(object=bone, analysis="logistic")
 summary(object=bone, analysis="logistic", 
         periodic.angles=seq(from=-0.1, to=0.1, length.out=10))
}
}
\seealso{
Other BoneProfileR: 
\code{\link{BP_AutoFit}()},
\code{\link{BP_ChooseBackground}()},
\code{\link{BP_ChooseCenter}()},
\code{\link{BP_ChooseForeground}()},
\code{\link{BP_DetectBackground}()},
\code{\link{BP_DetectCenters}()},
\code{\link{BP_DetectForeground}()},
\code{\link{BP_DuplicateAnalysis}()},
\code{\link{BP_EstimateCompactness}()},
\code{\link{BP_FitBayesianCompactness}()},
\code{\link{BP_FitBayesianPeriodicCompactness}()},
\code{\link{BP_FitMLCompactness}()},
\code{\link{BP_FitMLPeriodicCompactness}()},
\code{\link{BP_FitMLRadialCompactness}()},
\code{\link{BP_GetFittedParameters}()},
\code{\link{BP_ListAnalyses}()},
\code{\link{BP_LnLCompactness}()},
\code{\link{BP_OpenImage}()},
\code{\link{BP_Report}()},
\code{\link{Erinaceus_europaeus}},
\code{\link{plot.BoneProfileR}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{BoneProfileR}
