% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_boundary.R
\name{define_boundary}
\alias{define_boundary}
\title{Define the boundary elements of a SpatRaster with numeric data or boundary intensities}
\usage{
define_boundary(x, cat = FALSE, threshold = 0.2, calculate_intensity = FALSE)
}
\arguments{
\item{x}{A SpatRaster object.}

\item{cat}{TRUE if the input SpatRaster contains a categorical variable. default = FALSE.}

\item{threshold}{A value between 0 and 1. The proportion of cells to keep as boundary elements. default = 0.2.}

\item{calculate_intensity}{logical. If TRUE, calculate boundary intensity at each cell from trait data. default = FALSE.}
}
\value{
A SpatRaster object with cell values 1 for boundary elements and 0 for other cells
}
\description{
Defines boundary elements in a SpatRaster object.

For categorical traits, boundary elements are defined as cells that neighbor a patch with a different value.

If the trait is quantitative, function will keep a proportion of the cells with the highest boundary intensity values,
with a threshold chosen by the user. If the SpatRaster contains trait values, boundary intensity values can be
calculated (calculate_intensity = T) using a Sobel-Feldman operator.

In some cases, there may be many redundant values for boundary intensity. If the threshold is set to cut off the values
at those points, the actual proportion of cells categorized as boundary elements would differ from the intended
threshold. The function reports the proportion of cells that are boundary elements, so that users can choose a
different value, if necessary.
}
\examples{
\donttest{
data(grassland)
grassland <- terra::rast(grassland_matrix, crs = grassland_crs)
terra::ext(grassland) <- grassland_ext

grassland_boundaries <- define_boundary(grassland, threshold = 0.1)
}

}
\references{
Fortin, M.J. et al. (2000) Issues related to the detection of boundaries. Landscape Ecology, 15, 453-466.
Jacquez, G.M., Maruca,I S. & Fortin M.-J. (2000) From fields to objects: A review of geographic boundary analysis. Journal of Geographical Systems, 3, 221, 241.
}
\author{
Amy Luo
}
