% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population2sample.test.MinPv.R
\name{population2sample.test.MinPv}
\alias{population2sample.test.MinPv}
\title{Identify differences of partial correlations between two populations using Genovese and Wasserman's method}
\usage{
population2sample.test.MinPv(
  popEst1,
  popEst2,
  alpha = 0.05,
  c0 = 0.1,
  targetSet = NULL,
  simplify = !is.null(targetSet)
)
}
\arguments{
\item{popEst1}{A \code{popEst} class object.}

\item{popEst2}{A \code{popEst} class object.}

\item{alpha}{significance level, default value is \code{0.05}.}

\item{c0}{threshold of the exceedance rate of FDP,
default value is \code{0.1}.}

\item{targetSet}{a two-column matrix. Each row contains two index corresponding to a pair of variables of interest.
If \code{NULL}, any pair of two variables is considered to be of interest.}

\item{simplify}{a logical indicating whether results should be simplified if possible.}
}
\value{
If \code{simplify} is \code{FALSE}, a \eqn{p*p} matrix with values 0 or 1 is returned, and 1 means unequal.

And if \code{simplify} is \code{TRUE}, a two-column matrix is returned,
indicating the row index and the column index of recovered unequal partial correlations.
Those with lower p values are sorted first.
}
\description{
Identify differences of partial correlations between two populations
in two groups of time series data,
based on controlling the rate of the false discovery proportion (FDP) exceeding \eqn{c0}
at \eqn{\alpha}. The method is based on the minimum of the p-values.
Input two \code{popEst} class objects returned by \code{\link{population.est}}
(the number of individuals in two groups can be different).
\cr
\cr
}
\examples{
## Quick example for the two-sample case inference
data(popsimA)
data(popsimB)
# estimating partial correlation coefficients by lasso (scaled lasso does the same)
pc1 = population.est(popsimA, type = 'l')
pc2 = population.est(popsimB, type = 'l')
# conducting hypothesis test
Res = population2sample.test.MinPv(pc1, pc2)

}
\references{
Genovese C., and Wasserman L. (2006).
Exceedance Control of the False Discovery Proportion,
\emph{Journal of the American Statistical Association}, 101, 1408-1417

Qiu Y. and Zhou X. (2021).
Inference on multi-level partial correlations
based on multi-subject time series data,
\emph{Journal of the American Statistical Association}, 00, 1-15.
}
