% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/max_eto_grid_download.R
\name{max_eto_grid_download}
\alias{max_eto_grid_download}
\title{Download maximum reference evapotranspiration (ETo) grids for Brazil}
\usage{
max_eto_grid_download(dir_out, product = "max_12_months")
}
\arguments{
\item{dir_out}{Character. Directory where the downloaded raster file will be saved.}

\item{product}{Character. Specifies which maximum ETo product to download.
Available options include:
\itemize{
  \item \code{max_12_months}: maximum ETo over the full year.
  \item \code{max_jan} to \code{max_dec}: monthly maximum ETo for each respective month (January to December).
}}
}
\value{
A `SpatRaster` object containing the downloaded maximum reference evapotranspiration (ETo) grid.
}
\description{
Downloads maximum reference evapotranspiration (ETo) grids for Brazil, intended for irrigation design purposes. 
The dataset was developed by Dias (2018).
}
\examples{
\dontrun{
# Visualize Brazilian states (optional)
see_brazil_states()

# Download maximum ETo grid (annual)
img_max_eto <- max_eto_grid_download(dir_out = "data/", product = "max_12_months")
}

}
\references{
Dias, S. H. B. (2018). *Evapotranspiração de referência para projeto de irrigação no Brasil utilizando o produto MOD16*. Dissertação (Mestrado) – Universidade Federal de Viçosa.
}
\author{
Roberto Filgueiras.
}
