% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rows_cntr.R
\name{rows.cntr}
\alias{rows.cntr}
\title{Rows contribution chart}
\usage{
rows.cntr(
  data,
  x = 1,
  categ.sort = TRUE,
  corr.thrs = 0,
  leg = TRUE,
  cex.labls = 0.75,
  dotprightm = 5,
  cex.leg = 0.6,
  leg.x.spc = 1,
  leg.y.spc = 1
)
}
\arguments{
\item{data}{Name of the dataset (must be in dataframe format).}

\item{x}{Dimension for which the row categories contribution is returned (1st
dimension by default).}

\item{categ.sort}{Logical value (TRUE/FALSE) which allows to sort the categories in
descending order of contribution to the inertia of the selected dimension.
TRUE is set by default.}

\item{corr.thrs}{Threshold above which the column categories correlation will
be displayed in the plot's legend.}

\item{leg}{Enable (TRUE; default) or disable (FALSE) the legend at the
right-hand side of the dot plot.}

\item{cex.labls}{Adjust the size of the dot plot's labels.}

\item{dotprightm}{Increases the empty space between the right margin of the
dot plot and the left margin of the legend box.}

\item{cex.leg}{Adjust the size of the legend's characters.}

\item{leg.x.spc}{Adjust the horizontal space of the chart's legend. See more
info from the 'legend' function's help (?legend).}

\item{leg.y.spc}{Adjust the y interspace of the chart's legend. See more info
from the 'legend' function's help (?legend).}
}
\description{
This function allows to calculate the contribution of the row categories to
the selected dimension.
}
\details{
The function displays the contribution of the categories as a dot plot. A
reference line indicates the threshold above which a contribution can be
considered important for the determination of the selected dimension. The
parameter categ.sort=TRUE sorts the categories in descending order of contribution
to the inertia of the selected dimension. At the left-hand side of the plot,
the categories' labels are given a symbol (+ or -) according to whether each
category is actually contributing to the definition of the positive or
negative side of the dimension, respectively. The categories are grouped into
two groups: 'major' and 'minor' contributors to the inertia of the selected
dimension. At the right-hand side, a legend (which is enabled/disabled using
the 'leg' parameter) reports the correlation (sqrt(COS2)) of the column
categories with the selected dimension. A symbol (+ or -) indicates with
which side of the selected dimension each column category is correlated.
}
\examples{
data(greenacre_data)

#Plots the contribution of the row categories to the 2nd CA dimension,
#and also displays the contribnution to the total inertia.
#The categories are sorted in descending order of contribution to the inertia
#of the selected dimension.
rows.cntr(greenacre_data, 2, categ.sort=TRUE)

}
\seealso{
\code{\link{rows.cntr.scatter}} , \code{\link{cols.cntr}} ,
 \code{\link{cols.cntr.scatter}}
}
\keyword{rows.cntr}
