% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experimental-features.R
\name{fit_curve_eds}
\alias{fit_curve_eds}
\title{Fit dose-response models and calculate summary statistics for ED5, ED50, and ED95 values.}
\usage{
fit_curve_eds(
  cbass_dataset,
  grouping_properties = c("Site", "Condition", "Species", "Timepoint"),
  drm_formula = "Pam_value ~ Temperature"
)
}
\arguments{
\item{cbass_dataset}{A data frame containing the dataset to be processed.}

\item{grouping_properties}{A character vector of column names to be used for grouping. Default: c("Site", "Condition", "Species", "Timepoint").}

\item{drm_formula}{A formula object specifying the dose-response model. Default: "Pam_value ~ Temperature".}
}
\value{
A data frame with summary statistics for ED5, ED50, and ED95 values.
}
\description{
Fit dose-response models and calculate summary statistics for ED5, ED50, and ED95 values.
}
\examples{
# Example dataset
data(cbass_dataset)

# Example grouping properties
grouping_properties <- c("Site", "Condition", "Species", "Timepoint")

# Extract the ED5, ED50, and ED95 values as a data frame
fitted_edss_df <- fit_curve_eds(cbass_dataset, grouping_properties)
}
