% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CDVineCopulaConditional.r
\name{overplot}
\alias{overplot}
\title{overplot}
\usage{
overplot(data1, data2, col1 = "black", col2 = "grey", xlim = NA,
  ylim = NA, labels = NA, method = "pearson", cex.cor = 1,
  cex.labels = 1, cor.signif = 2, cex.axis = 1, pch1 = 1, pch2 = 1)
}
\arguments{
\item{data1, data2}{Two \code{N x d} matrices of data to be plotted.}

\item{col1, col2}{Colors used for \code{data1} and \code{data2} during the plot. Default is \code{col1="black"} and \code{col2="grey"}.}

\item{xlim, ylim}{Two bidimensional vectors indicating the limits of x and y axes for all the scatterplots. 
If not given, they are authomatically 
computed for each of the scatterplots.}

\item{labels}{A character vector with the variable names to be printed (if not given, the names of \code{data1} 
variables are printed).}

\item{method}{Character indicating the dependence types to be computed between the pairs. Possibilites: "kendall",
"spearman" and "pearson" (default)}

\item{cex.cor}{Number: character dimension of the printed dependencies. Default \code{cex.cor=1}.}

\item{cex.labels}{Number: character dimension of the printed variable names. Default \code{cex.labels=1}.}

\item{cor.signif}{Number: number of significant numbers of the printed dependencies. Default \code{cor.signif=2}.}

\item{cex.axis}{Number: dimension of the axis numeric values. Default cex.axis=1.}

\item{pch1, pch2}{Paramter to specify the symbols to use when plotting points of \code{data1} and \code{data2}.Default is \code{pch1=1} and \code{pch2=1}.}
}
\value{
A matrix of overlaying scatterplots of the multivariate datsets \code{data1} and \code{data2}, with 
the dependencies of the pairs.
}
\description{
This function overlays the scatterplot matrices of two multivariate datsets. 
Moreover, it shows the dependencies among all the pairs for both datsets.
}
\examples{

# Example 1

# Read and prepare the data for the plot
data(dataset) 
data1 <- dataset$data[1:300,]
data2 <- dataset$data[301:600,]
overplot(data1,data2,xlim=c(0,1),ylim=c(0,1),method="kendall")



\dontrun{
# Example 2

# Read and prepare the data for the plot
data(dataset) 
data <- dataset$data[1:200,1:5]
colnames(data) <- c("Y1","Y2","X3","X4","X5")

# Fit copula families for the defined vine:
ListVines <- CDVineCondListMatrices(data,Nx=3)
Matrix=ListVines$CVine[[1]]
RVM <- CDVineCondFit(data,Nx=3,Matrix=Matrix)

# Simulate data:
d=dim(RVM$Matrix)[1]
cond1 <- data[,RVM$Matrix[(d+1)-1,(d+1)-1]]
cond2 <- data[,RVM$Matrix[(d+1)-2,(d+1)-2]]
cond3 <- data[,RVM$Matrix[(d+1)-3,(d+1)-3]]
condition <- cbind(cond1,cond2,cond3)
Sim <- CDVineCondSim(RVM,condition)

# Plot the simulated variables Sim over the observed
Sim <- data.frame(Sim)
overplot(data[,1:2],Sim[,1:2],xlim=c(0,1),ylim=c(0,1),method="spearman")
overplot(data,Sim,xlim=c(0,1),ylim=c(0,1),method="spearman")
}

}
\author{
Emanuele Bevacqua
}

