% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SU_status.R
\name{SU_status}
\alias{SU_status}
\title{Substance Use status detection in North American Healthcare Administrative Databases}
\usage{
SU_status(inputdata, n_SUH, n_SUP, t_SU, ICD_SU)
}
\arguments{
\item{inputdata}{a dataframe including columns: ClientID,  VisitDate,  Diagnostic_H, and Diagnostic_P}

\item{n_SUH}{minimum number of potential substance use related hospital visits}

\item{n_SUP}{minimum number of potential substance use related medical service physician visits}

\item{t_SU}{maximum time lag (in days) between all hospital visits and all medical service physician visits}

\item{ICD_SU}{plausible list of Substance Use status diagnostic codes}
}
\value{
a dataframe matrix with  Clients' ID, earliest date of Substance Use, latest date of Substance Use, and Substance Use status
}
\description{
Substance Use status is detected in North American Healthcare Administrative Databases  using clinician's parameters of interest such as minimum number of hospital visits, minimum number of physician services, time lag between them and plausible ICD diagnostics.
}
\examples{
data(SampleRWD)
myexample <- SampleRWD[,c(1:4)]
SampleSU_1 <- SU_status(myexample,
n_SUH=1, n_SUP=1,  t_SU=60,
ICD_SU=c("F100","T4041","F120","F140"))
head(SampleSU_1)

}
\references{
Khan S. (2017). Concurrent mental and substance use disorders in Canada. Health reports, 28(8), 3–8, Ottawa, ON, Canada, PMID: 29044442. https://pubmed.ncbi.nlm.nih.gov/29044442/
Canadian Institute for Health Information. (2022). Canadian coding standards for version 2022 ICD-10-CA and CCI. Canadian Institute for Health Information. Ottawa, Ontario, Canada. https://www.cihi.ca/en/version-2022-icd-10-cacci-classifications-canadian-coding-standards-and-related-products
Centers for Disease Control and Prevention. (2024). International classification of diseases, tenth revision, clinical modification (ICD-10-CM) 2024. National Center for Health Statistics. Atlanta, GA, United States. https://www.cdc.gov/nchs/icd/icd-10-cm/index.html
Casillas, S. M., Scholl, L., Mustaquim, D., & Vivolo-Kantor, A. (2022). Analysis of trends and usage of ICD-10-CM discharge diagnosis codes for poisonings by fentanyl, tramadol, and other synthetic narcotics in emergency department data. Addictive Behaviors Reports, 16, 100464. Atlanta, GA, USA. https://doi.org/10.1016/j.abrep.2022.100464
}
