% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/w_j_2stage.R
\name{w_j_2stage}
\alias{w_j_2stage}
\title{Compute E-step for Two-Stage Binary Outcome Misclassification Model Estimated With the EM-Algorithm}
\usage{
w_j_2stage(
  ystar_matrix,
  ytilde_matrix,
  pitilde_array,
  pistar_matrix,
  pi_matrix,
  sample_size,
  n_cat
)
}
\arguments{
\item{ystar_matrix}{A numeric matrix of indicator variables (0, 1) for the observed
outcome \code{Y*}. Rows of the matrix correspond to each subject. Columns of
the matrix correspond to each observed outcome category. Each row should contain
exactly one 0 entry and exactly one 1 entry.}

\item{ytilde_matrix}{A numeric matrix of indicator variables (0, 1) for the observed
outcome \eqn{\tilde{Y}}. Rows of the matrix correspond to each subject. Columns of
the matrix correspond to each observed outcome category. Each row should contain
exactly one 0 entry and exactly one 1 entry.}

\item{pitilde_array}{A numeric array of conditional probabilities obtained from
the internal function \code{pitilde_compute}. Rows of the matrices correspond
to each subject and to each second-stage observed outcome category. Columns of the matrix correspond
to each first-stage observed outcome category. The third dimension of the array
corresponds to each true, latent outcome category.}

\item{pistar_matrix}{A numeric matrix of conditional probabilities obtained from
the internal function \code{pistar_compute}. Rows of the matrix correspond to
each subject and to each first-stage observed outcome category. Columns of the matrix
correspond to each true, latent outcome category.}

\item{pi_matrix}{A numeric matrix of probabilities obtained from the internal
function \code{pi_compute}. Rows of the matrix correspond to each subject.
Columns of the matrix correspond to each true, latent outcome category.}

\item{sample_size}{An integer value specifying the number of observations in
the sample. This value should be equal to the number of rows of the observed
outcome matrices, \code{ystar_matrix} and \code{ytilde_matrix}.}

\item{n_cat}{The number of categorical values that the true outcome, \code{Y},
and the observed outcomes can take.}
}
\value{
\code{w_j} returns a matrix of E-step weights for the EM-algorithm,
computed as follows:
\eqn{\sum_{k = 1}^2 \sum_{\ell = 1}^2 \frac{y^*_{ik} \tilde{y}_{i \ell} \tilde{\pi}_{i \ell kj} \pi^*_{ikj} \pi_{ij}}{\sum_{h = 1}^2 \tilde{\pi}_{i \ell kh} \pi^*_{ikh} \pi_{ih}}}.
Rows of the matrix correspond to each subject. Columns of the matrix correspond
to the true outcome categories \eqn{j = 1, \dots,} \code{n_cat}.
}
\description{
Compute E-step for Two-Stage Binary Outcome Misclassification Model Estimated With the EM-Algorithm
}
