% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ahp_beta.R
\name{AHP.Beta}
\alias{AHP.Beta}
\title{Probabilistic AHP using Beta PERT distributions}
\usage{
AHP.Beta(n, s, list)
}
\arguments{
\item{n}{Random numbers created from Beta PERT distributions, using the parameters 'min', 'mean' and 'max' of each pair-wise criteria comparison elicited from the experts.}

\item{s}{Shape of a Beta PERT distribution, as described in package "mc2d". There is no default value, however the higher the shape the higher the kurtosis, which emulates the precision of data elicited from experts.}

\item{list}{List of pair-wise comparison matrices of expert opinions. The function 'list' is embedded in R.}
}
\value{
Weights returned from a simulation of AHP with Beta PERT distributions. The weights are driven from the simulated matrix that gives the minimum AHP Consistent Ratio.
}
\description{
This function computes criteria weights, using AHP and randomic pair-wise evaluations by Beta PERT distributions.
}
\examples{
n=5000 # simulation
s=6 # shape of Beta PERT distribution
# Expert pair-wise evaluations
Exp.1 = matrix(c(1,0.2,0.3,5,1,0.2,3,5,1),3,3)
Exp.2 = matrix(c(1,2,8,0.5,1,6,0.12,0.16,1),3,3)
Exp.3 = matrix(c(1,0.5,0.5,2,1,6,2,0.16,1),3,3)
Exp.4 = matrix(c(1,3,4,0.3,1,0.5,0.25,0.3,1),3,3)
Exp.5 = matrix(c(1,4,5,0.25,1,1,0.2,1,1),3,3)
list = list(Exp.1,Exp.2,Exp.3,Exp.4,Exp.5)
AHP.Beta(n,s,list)
}
\references{
Saaty, Thomas L. (1980). The analytic hierarchy process: planning, priority setting, resource allocation, McGraw-Hill.
}
