% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpp_rh.R
\name{CPP.rh}
\alias{CPP.rh}
\title{CPP with multiple perspectives for human resources evaluation}
\usage{
CPP.rh(t1, t2, q, s)
}
\arguments{
\item{t1}{Decision matrix of Alternatives (rows) and Criteria (columns) in the previous moment '1'. Benefit criteria must be positive and cost criteria must be negative.}

\item{t2}{Decision matrix of Alternatives (rows) and Criteria (columns) in the following moment '2'. Benefit criteria must be positive and cost criteria must be negative.}

\item{q}{Vector of quantiles, indicating the classes' profiles.}

\item{s}{Shape of a Beta PERT distribution, as described in the package 'mc2d'. There is no default value, however the higher the shape the higher the kurtosis, which emulates the precision of data.}
}
\value{
Class identifies the alternatives' classes, according to the selected profiles. CPP-RH returns the alternatives' scores per class.
}
\description{
This function computes the CPP-rh, using Beta PERT distributions to randomize the decision matrices. The CPP-rh is used to evaluate alternatives by integrating the CPP-Tri, the CPP-Malmquist, the CPP-Gini and the CPP by axes. The CPP-rh and the CPP-mb are very similar, but the CPP-rh does not include the alternatives's market value.
}
\examples{
## Decision matrix of the previous moment '1'.
Alt.1 = c(2,30,86,-5)
Alt.2 = c(4,26,77,-12)
Alt.3 = c(3,22,93,-4)
Alt.4 = c(6,34,65,-10)
Alt.5 = c(5,31,80,-8)
Alt.6 = c(6,29,79,-9)
Alt.7 = c(8,37,55,-15)
Alt.8 = c(10,21,69,-11)
t1 = rbind(Alt.1,Alt.2,Alt.3,Alt.4,Alt.5,Alt.6,Alt.7,Alt.8)
## Decision matrix of the following moment '2'.
Alt.1 = c(3,29,82,-3)
Alt.2 = c(6,28,70,-8)
Alt.3 = c(2,20,99,-8)
Alt.4 = c(5,31,62,-14)
Alt.5 = c(9,27,73,-5)
Alt.6 = c(4,33,85,-13)
Alt.7 = c(9,39,59,-10)
Alt.8 = c(8,19,77,-9)
t2 = rbind(Alt.1,Alt.2,Alt.3,Alt.4,Alt.5,Alt.6,Alt.7,Alt.8)
q = c(0.65,0.35) # quantiles of class profiles
s = 4 # Shape
CPP.rh(t1,t2,q,s)
}
