% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_pith.R
\name{detect_pith}
\alias{detect_pith}
\title{Automatically detect pith in a CT scan image}
\usage{
detect_pith(
  im,
  toPlot = TRUE,
  n_segments = 25,
  flag = TRUE,
  x_0 = 0.5,
  y_0 = 0.5,
  n_run_max = 15,
  threshold = 0.1,
  pixel = TRUE
)
}
\arguments{
\item{im}{Matrix of the CT scan image}

\item{toPlot}{Boolean to plot the location of the pith on the image}

\item{n_segments}{Number of segements used to locate pith}

\item{flag}{FALSE if pith location is known}

\item{x_0}{Estimate of pith location in x}

\item{y_0}{Estimate of pith location in y}

\item{n_run_max}{Maximum number of iterations}

\item{threshold}{Thershold value for identifying ring transition points}

\item{pixel}{If TRUE, returns x,y coordinates in pixel numbers, else FALSE returns x,y coordinates in relative values of x and y}
}
\value{
x,y pith coordinates
}
\description{
Automatically detect pith in a CT scan image
}
\examples{
library(oro.dicom)
file_path <- system.file("extdata", "disk.dcm", package = "CTRing")
dcm <-  readDICOM(file_path)
hdr_df <- dcm$hdr[[1]]
image_info <- getImageInfo(hdr = hdr_df)

im <- imageToMatrix(dcm$img)
im_8bit <- xBitTo8Bit(im, image_info$grayScale)
im_dens <- grayToDensity(im_8bit)

pith_coord <- detect_pith(im_dens, n_segments = 12, pixel = TRUE, toPlot = FALSE)

}
