% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PRM_DT.R
\name{PRM_DT}
\alias{PRM_DT}
\title{PRM Data Table Function}
\usage{
PRM_DT(PRM_data, fill_cols = NULL, colour_cols = NULL)
}
\arguments{
\item{PRM_data}{a data frame of either daily average or wet season PRM values}

\item{fill_cols}{A vector of column names of pesticide groups to fill colour
with corresponding PRM risk category}

\item{colour_cols}{A vector of column names of pesticide groups to colour
text with corresponding PRM risk category}
}
\value{
a data table colour coded to PRM risk
}
\description{
PRM Data Table Function
}
\examples{
Canto_pesticides_LOR_treated <- treat_LORs_all_data(raw_data = Canto_pesticides,
pesticide_info = CalcThemAll.PRM::pesticide_info)
Canto_daily_PRM <- calculate_daily_average_PRM(LOR_treated_data = Canto_pesticides_LOR_treated)
PRM_DT(PRM_data = Canto_daily_PRM, fill_cols = "Total PRM",
colour_cols = c("PSII Herbicide PRM", "Other Herbicide PRM", "Insecticide PRM"))

}
