% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_mbsts.R
\name{predict.mbsts}
\alias{predict.mbsts}
\title{Predictions for a given multivariate Bayesian structural time series model}
\usage{
\method{predict}{mbsts}(object, steps.ahead, newdata = NULL, ...)
}
\arguments{
\item{object}{An object of class 'mbsts', a result of call to \code{\link{as.mbsts}}.}

\item{steps.ahead}{An integer value (S) specifying the number of steps ahead
to be forecasted. If 'object' contains a regression component, the argument
is disregarded and a prediction is made with the same length of
'newdata'.}

\item{newdata}{Optional matrix of new data. Only required when 'object'
contains a regression component.}

\item{...}{Arguments passed to other methods (currently unused).}
}
\value{
Returns a list with the following components
\describe{
  \item{post.pred.0}{t x d x ('niter'- 'burn') array of in-sample forecasts.}
  \item{post.pred.1}{S x d x ('niter'- 'burn') array out-of-sample forecasts, where S is
        the number of forecasted periods (set to the length of 'steps.ahead' or 'newdata').}
  \item{post.pred}{(t + S) x d x ('niter'- 'burn') array combining in- and out-of-sample forecasts.}
}
}
\description{
Given an object of class 'mbsts' and the number of 'steps.ahead' in the future to be
forecasted, this function provides in-sample forecasts and out-of-sample forecasts,
both based on drawing from the posterior predictive distribution. If 'mbsts' contains a
regression component, then the new matrix of predictors 'newdata' must be provided.
Note that NA values are not allowed in the new regressor matrix.
}
\examples{
## Note: The following are toy examples, for a proper analysis we recommend to run
##       at least 1000 iterations and check the convergence of the Markov chain

## Example 1 :
y <- cbind(seq(0.5,100,by=0.5)*0.1 + rnorm(200),
           seq(100.25,150,by=0.25)*0.05 + rnorm(200),
           rnorm(200, 5,1))
mbsts.1 <- as.mbsts(y = y, components = c("trend", "seasonal"), seas.period = 7, s0.r = diag(3),
                    s0.eps = diag(3), niter = 50, burn = 5)
pred.1 <- predict(mbsts.1, steps.ahead = 10)

## Example 2
y <- cbind(rnorm(100), rnorm(100, 2, 3))
X <- cbind(rnorm(100, 0.5, 1) + 5, rnorm(100, 0.2, 2) - 2)
mbsts.2 <- as.mbsts(y = y, components = c("trend", "seasonal"),
                    seas.period = 7, X = X, s0.r = diag(2),
                    s0.eps = diag(2), niter = 100, burn = 10)
newdata <- cbind(rnorm(30), rt(30, 2))
pred.2 <- predict(mbsts.2, newdata = newdata)
}
