% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SigmasClass.R
\name{Sigmas}
\alias{Sigmas}
\title{Create an instance of Sigmas class.}
\usage{
Sigmas(
  Additive = 0,
  LogAdditive = 0,
  Proportional = 0.1,
  AdditiveMultiplicative = list(PropPart = 0, AddPart = 0),
  MixRatio = list(PropPart = 0, AddPart = 0),
  Power = list(PowerPart = 0, StdevPart = 0),
  ObservationName = ""
)
}
\arguments{
\item{Additive}{The additive error sigma value.}

\item{LogAdditive}{The log-additive error sigma value.}

\item{Proportional}{The proportional error sigma value.}

\item{AdditiveMultiplicative}{A list specifying the additive and
multiplicative parts for the additive-multiplicative error model. The list
should have elements \code{PropPart} and \code{AddPart}. Alternatively the
proportional part (\code{PropPart}) could be presented as \code{StParm}, see
\code{\link[=StParm]{StParm()}}.}

\item{MixRatio}{A list specifying the proportional and additive parts for the
mix-ratio error model. The list should have elements \code{PropPart} and
\code{AddPart}. Alternatively the proportional part (\code{PropPart}) could be
presented as \code{StParm}, see \code{\link[=StParm]{StParm()}}.}

\item{Power}{A numeric vector specifying the standard deviation and power
parts for the power error model. The vector should have names \code{StdevPart}
and \code{PowerPart}.}

\item{ObservationName}{A character string giving the name of the Observation.}
}
\value{
A Sigmas class instance.
}
\description{
This function creates a new instance of different error models object to be
applied. 0s are treated as no values.
}
\examples{
RSE_CObs <-
  Observation(SigmasChosen =
    Sigmas(MixRatio = list(PropPart = 2,
                           AddPart = 0.01),
           Proportional = 0))
models <-
  create_ModelPK(CompartmentsNumber = 2,
                 CObs = RSE_CObs)
print(models)

}
\seealso{
Functions used for Observation specification: 
\code{\link{Observation}()},
\code{\link{ObservationCustom}()},
\code{\link{create_ModelPD}()},
\code{\link{create_ModelPK}()},
\code{\link{modify_Observation}()},
\code{\link{remove_Observation}()}
}
\concept{Observations}
