% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFunctions.R
\name{exampleOmopConnectionDetails}
\alias{exampleOmopConnectionDetails}
\title{create a connection detail for an example GI Bleed dataset from Eunomia}
\usage{
exampleOmopConnectionDetails(exdir = tempdir())
}
\arguments{
\item{exdir}{a directory to unzip the example OMOP database into.  Default is tempdir().}
}
\value{
An object of class `ConnectionDetails` with the details to connect to the example OHDSI OMOP CDM database
}
\description{
This returns an object of class `ConnectionDetails` that lets you connect via `DatabaseConnector::connect()` to the example database.
}
\details{
Finds the location of the example database in the package and calls `DatabaseConnector::createConnectionDetails` to create a `ConnectionDetails` object for connecting to the database.
}
\examples{
conDet <- exampleOmopConnectionDetails()

connectionHandler <- ResultModelManager::ConnectionHandler$new(conDet)

}
\concept{helper}
