\name{nntsmanifoldnewtonestimationsymmetry}
\alias{nntsmanifoldnewtonestimationsymmetry}
\title{Parameter estimation for NNTS symmetric distributions}
\description{Computes the maximum likelihood estimates of the NNTS parameters of an NNTS symmetric distribution, using a Newton algorithm on the hypersphere}
\usage{nntsmanifoldnewtonestimationsymmetry(data, M = 0,iter=1000,gradientstop=1e-10,
pevalmu=1000,initialpoint=FALSE,cinitial)}

\arguments{
  \item{data}{Vector of angles in radians}
  \item{M}{Number of components in the NNTS symmetric density}
  \item{iter}{Number of iterations}
  \item{gradientstop}{The minimum value of the norm of the gradient to stop the Newton algorithm on the hypersphere}
  \item{pevalmu}{Number of equidistant points in the interval 0 to 2pi to search for the maxima of the angle of symmetry}
  \item{initialpoint}{TRUE if an initial point for the optimization algorithm for the general (asymmetric) NNTS density will be used}
  \item{cinitial}{Vector of size M+1. The first element is real and the next M elements are complex (values for $c_0$ and $c_1, ...,c_M$). The sum of the squared moduli of the parameters must be equal to 1/(2*pi). This is the vector of parameters for the general (asymmetric) NNTS density}
}

\value{
  \item{cestimatessym}{Matrix of (M+1)x2. The first column is the parameter numbers, and the second column is the c parameter's estimators of the symmetric NNTS model}
  \item{mu}{Estimate of the angle of symmetry of the NNTS symmetric model}
  \item{logliksym}{Optimum log-likelihood value for the NNTS symmetric model}
  \item{AICsym}{Value of Akaike's Information Criterion for the NNTS symmetric model}
  \item{BICsym}{Value of Bayesian Information Criterion for the NNTS symmetric model}
  \item{gradnormerrorsym}{Gradient error after the last iteration for the estimation of the parameters of the NNTS symmetric model}
  \item{cestimatesnonsym}{Matrix of (M+1)x2. The first column is the parameter numbers, and the second column is the c parameter's estimators of the symmetric NNTS model}
  \item{logliknonsym}{Optimum log-likelihood value for the general (non-symmetric) NNTS model}
  \item{AICnonsym}{Value of Akaike's Information Criterion for the general (non-symmetric) NNTS model}
  \item{BICnonsym}{Value of Bayesian Information Criterion for the general (non-symmetric) NNTS model}
  \item{gradnormerrornonsym}{Gradient error after the last iteration for the estimation of the parameters of the general (non-symmetric) NNTS model}
  \item{loglikratioforsym}{Value of the likelihood ratio test statistic for symmetry}
  \item{loglikratioforsympvalue}{Value of the asymptotic chi squared p-value of the likelihood ratio test statistic for symmetry}
}
\references{
Fernández-Durán, J.J., Gregorio-Domínguez, M.M. (2025). Multimodal Symmetric Circular Distributions Based on Nonnegative Trigonometric Sums and a Likelihood Ratio Test for Reflective Symmetry, arXiv:2412.19501 [stat.ME]
(available at https://arxiv.org/abs/2412.19501)}
\author{Juan Jose Fernandez-Duran y Maria Mercedes Gregorio-Dominguez}

\examples{
data(Turtles_radians)
resturtlessymm<-nntsmanifoldnewtonestimationsymmetry(data=Turtles_radians, M = 2, iter =1000,
gradientstop=1e-10,pevalmu=1000)
resturtlessymm
hist(Turtles_radians,breaks=seq(0,2*pi,2*pi/13),xlab="Direction (radians)",freq=FALSE,
ylab="",main="",ylim=c(0,.8),axes=FALSE)
nntsplot(resturtlessymm$cestimatessym[,2],2,add=TRUE)
nntsplot(resturtlessymm$cestimatesnonsym[,2],2,add=TRUE,lty=2)
axis(1,at=c(0,pi/2,pi,6*(pi/4),2*pi),labels=c("0",expression(pi/2),expression(pi),
expression(3*pi/2),expression(2*pi)),las=1)
axis(2)

data(Ants_radians)
resantssymm<-nntsmanifoldnewtonestimationsymmetry(data=Ants_radians, M = 4, iter =1000,
gradientstop=1e-10,pevalmu=1000)
resantssymm
hist(Ants_radians,breaks=seq(0,2*pi,2*pi/13),xlab="Direction (radians)",freq=FALSE,
ylab="",main="",ylim=c(0,.8),axes=FALSE)
nntsplot(resantssymm$cestimatessym[,2],4,add=TRUE)
nntsplot(resantssymm$cestimatesnonsym[,2],4,add=TRUE,lty=2)
axis(1,at=c(0,pi/2,pi,6*(pi/4),2*pi),labels=c("0",expression(pi/2),expression(pi),
expression(3*pi/2),expression(2*pi)),las=1)
axis(2)
}
