% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin_changes.R
\name{bin_changes}
\alias{bin_changes}
\title{Counts the changes in a series of time bins}
\usage{
bin_changes(change_times, time_bins)
}
\arguments{
\item{change_times}{A vector of ages in millions of years at which character changes are hypothesised to have occurred.}

\item{time_bins}{An object of class \code{timeBins}.}
}
\value{
A vector giving the number of changes for each time bin. Names indicate the maximum and minimum (bottom and top) values for each time bin.
}
\description{
Given a vector of dates for a series of time bins and another for the times when a character change occurred will return the total number of changes in each bin.
}
\details{
Calculates the total number of evolutionary changes in a series of time bins. This is intended as an internal function for rate calculations, but could be used for other purposes (e.g., counting any point events in a series of time bins).
}
\examples{

# Create a random dataset of 100 changes (between 100 and 0 Ma):
change_times <- stats::runif(n = 100, min = 0, max = 100)

# Create 10 equal-length time bins:
time_bins <- matrix(data = c(seq(from = 100, to = 10, length.out = 10),
  seq(from = 90, to = 0, length.out = 10)), ncol = 2,
  dimnames = list(LETTERS[1:10], c("fad", "lad")))

# Set class as timeBins:
class(time_bins) <- "timeBins"

# Get N changes for each bin:
bin_changes(change_times = change_times, time_bins = time_bins)
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
