% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permute_graph_splits.r
\name{permute_graph_splits}
\alias{permute_graph_splits}
\title{Permute all ways to split a graph}
\usage{
permute_graph_splits(adjacency_matrix)
}
\arguments{
\item{adjacency_matrix}{A labelled adjacency matrix where the diagonal is zeroes and the off-diagonal either ones (if the two vertices are directly connected) or zeroes (if not directly connected). Labels must match across row names and column names,}
}
\value{
A vector of splits where connected vert(ices) are listed with "+" joining them and disconnected vert(ices) are separated by "|".
}
\description{
Given a graph represented by an adjacency matrix, permutes all ways this graph could be split apart.
}
\details{
This function takes a connected graph and considers all the ways it \emph{could} be split by removing every possible combination of edges (inclusive of none and all).
}
\examples{

# Create a connected graph matrix:
adjacency_matrix <- matrix(
  data = c(
    0, 1, 0, 0, 1, 0,
    1, 0, 1, 0, 1, 0,
    0, 1, 0, 1, 0, 0,
    0, 0, 1, 0, 1, 1,
    1, 1, 0, 1, 0, 0,
    0, 0, 0, 1, 0, 0
  ),
  ncol = 6,
  byrow = TRUE,
  dimnames = list(
    LETTERS[1:6],
    LETTERS[1:6]
  )
)

# Check graph is connectedPermute all ways to split graph (remove edges):
permute_graph_splits(adjacency_matrix = adjacency_matrix)

}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
