% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permute_treeshapes.r
\name{permute_treeshapes}
\alias{permute_treeshapes}
\title{Permute all treeshapes of N tips}
\usage{
permute_treeshapes(n_tips, sort_by_resolution = TRUE)
}
\arguments{
\item{n_tips}{The number of tips required. Note that it may be very slow or not run at all if this value is too large.}

\item{sort_by_resolution}{Whether or not to sort the output by number of internal nodes (from 1 to N - 1). Defaults to \code{TRUE}.}
}
\value{
If \code{sort_by_resolution = TRUE} then returns a list of length N - 1, where each element is a character vector of treeshapes in Newick-style number format with that many internal nodes. I.e., the first value will always be the star tree. If \code{sort_by_resolution = FALSE} then will just be a character vector of treeshapes in Newick-style number format.
}
\description{
Given a number of tips, permutes all rooted unlabelled multifurcating trees (i.e., treeshapes).
}
\details{
A treeshape is essentially an unlabelled phylogenetic tree. Like other phylogenetic trees it has a root and tips, but (as you might expect) because it is unlabelled the tips have no specific identity. Thus the only information it contains is its' "shape" - the number of internal nodes and their descendants. This function permutes all \emph{unique} treeshapes and allows for multifurcations.

Note that unique means it excludes alternative rotations of individual branch points. For example, the trees ((2),1); and (1,(2)); are identical in information content and this function would only permute one of them.

The algorithm used here is loosely based on the partitions approach suggested in Felsenstein (2004), although to the best of my knowledge nobody else has formally created an algorithm to do this. (Felsenstein also lays out the expected number of such treeshapes for each value of N.)

Here treeshapes are encoded and output in a pseudo-Newick style format where labels are replaced with the number of tips, e.g.:

(((3),1),(1,(2)));

Thus each pair of parentheses represents an internal node, each number the number of tips, each comma separates sets of tips, and the semicolon denotes the root clade.
}
\examples{

# Permute all treeshapes of six tips:
permute_treeshapes(n_tips = 6)

}
\references{
Felsenstein, J., 2004. \emph{Inferring Phylogenies}. Sinauer Associates, Inc., Sunderland.
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
