% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.stateGraph.r
\name{print.stateGraph}
\alias{print.stateGraph}
\title{Compact display of a stategraph}
\usage{
\method{print}{stateGraph}(x, ...)
}
\arguments{
\item{x}{An object of class \code{"stateGraph"}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Nothing is directly returned, instead a text summary describing a \code{"stateGraph"} object is printed to the console.
}
\description{
Displays a compact summary of a stateGraph object.
}
\details{
Displays some basic summary information on a stateGraph object.
}
\examples{

# Make an example stategraph:
example_stategraph <- list(
  n_vertices = 6,
  n_arcs = 12,
  n_states = 6,
  single_states = as.character(x = 0:5),
  type = "custom",
  arcs = data.frame(
    from = as.character(x = c(0, 1, 0, 2, 2, 5, 1, 4, 5, 4, 3, 4)),
    to = as.character(x = c(1, 0, 2, 0, 5, 2, 4, 1, 4, 5, 4, 3)),
    weight = c(1, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1)
  ),
  vertices = data.frame(
    label = as.character(x = 0:5),
    in_degree = c(2, 2, 2, 1, 3, 2),
    out_degree = c(2, 2, 2, 1, 3, 2),
    eccentricity = c(3, 2, 3, 3, 2, 2),
    periphery = c(1, 0, 1, 1, 0, 0),
    centre = c(0, 1, 0, 0, 1, 1)
  ),
  radius = 2,
  diameter = 3,
  adjacency_matrix = matrix(
    data = c(
      0, 1, 1, 0, 0, 0,
      1, 0, 0, 0, 1, 0,
      1, 0, 0, 0, 0, 1,
      0, 0, 0, 0, 1, 0,
      0, 1, 0, 1, 0, 1,
      0, 0, 1, 0, 1, 0
    ),
    nrow = 6,
    byrow = TRUE,
    dimnames = list(0:5, 0:5)
  ),
  directed = FALSE,
  includes_polymorphisms = FALSE,
  polymorphism_costs = "additive",
  polymorphism_geometry = "simplex",
  polymorphism_distance = "euclidean",
  includes_uncertainties = FALSE,
  pruned = FALSE,
  dollo_penalty = 999,
  base_age = 100,
  weight = 1
)

# Set class as stateGraph:
class(x = example_stategraph) <- "stateGraph"

# Show print.stateGraph version:
print.stateGraph(x = example_stategraph)

}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
