% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icp.torus.R
\name{icp.torus.eval}
\alias{icp.torus.eval}
\title{Inductive prediction sets for each level}
\usage{
icp.torus.eval(icp.torus, level = 0.1, eval.point = grid.torus())
}
\arguments{
\item{icp.torus}{an object containing all values to compute the conformity
score, which will be constructed with \code{icp.torus}.}

\item{level}{either a scalar or a vector, or even \code{NULL}. Default value
is 0.1.}

\item{eval.point}{N x N numeric matrix on \eqn{[0, 2\pi)^2}. Default input is
\code{grid.torus}.}
}
\value{
returns a \code{cp} object with the boolean values which
  indicate whether each evaluation point is contained in the inductive
  conformal prediction sets for each given level.
}
\description{
\code{icp.torus.eval} evaluates whether each pre-specified evaluation point
  is contained in the inductive conformal prediction sets for each given
  level.
}
\examples{
\donttest{
data <- toydata1[, 1:2]

icp.torus <- icp.torus(data, model = "kmeans",
                       mixturefitmethod = "general",
                       J = 4, concentration = 25)

icp.torus.eval(icp.torus, level = c(0.1, 0.08), eval.point = grid.torus())
}
}
\references{
Jung, S., Park, K., & Kim, B. (2021). Clustering on the torus by conformal prediction. \emph{The Annals of Applied Statistics}, 15(4), 1583-1603.
}
\seealso{
\code{\link[ClusTorus]{grid.torus}}, \code{\link[ClusTorus]{icp.torus}}
}
