% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimationCondCopulas.R
\name{estimateNPCondCopula}
\alias{estimateNPCondCopula}
\title{Compute a kernel-based estimator of the conditional copula}
\usage{
estimateNPCondCopula(
  X1 = NULL,
  X2 = NULL,
  X3 = NULL,
  U1_,
  U2_,
  newX3,
  kernel,
  h,
  observedX1 = NULL,
  observedX2 = NULL,
  observedX3 = NULL
)
}
\arguments{
\item{X1, X2, X3}{vectors of observations of size \code{n}}

\item{U1_}{a vector of numbers in [0, 1]}

\item{U2_}{a vector of numbers in [0, 1]}

\item{newX3}{a vector of new values for the conditioning variable \code{X3}}

\item{kernel}{a character string describing the kernel to be used.
Possible choices are \code{Gaussian}, \code{Triangular} and \code{Epanechnikov}.}

\item{h}{the bandwidth to use in the estimation.}

\item{observedX1, observedX2, observedX3}{old parameter names for \code{X1},
\code{X2}, \code{X3}. Support for this will be removed at a later version.}
}
\value{
An array of dimension \code{(length(U1_, U2_, newX3))}
whose element in position (i, j, k) is
\eqn{\hat C_{1,2|3}(u_1, u_2 | X_3 = x_3)}
where \eqn{u_1} = U1_[i], \eqn{u_2} = U2_[j] and \eqn{x_3} = newX3[k]
}
\description{
Assuming that we observe a sample \eqn{(X_{i,1}, X_{i,2}, X_{i,3}), i=1, \dots, n},
this function returns a array
\eqn{\hat C_{1,2|3}(u_1, u_2 | X_3 = x_3)}
for each choice of (u_1, u_2, x_3).
}
\examples{
# We simulate from a conditional copula
N = 500
X3 = rnorm(n = N, mean = 5, sd = 2)
conditionalTau = 0.9 * pnorm(X3, mean = 5, sd = 2)
simCopula = VineCopula::BiCopSim(N=N , family = 3,
    par = VineCopula::BiCopTau2Par(1 , conditionalTau ))
X1 = qnorm(simCopula[,1])
X2 = qnorm(simCopula[,2])

# We do the estimation
grid = c(0.2, 0.4, 0.6, 0.8)
arrayEst = estimateNPCondCopula(
  X1 = X1, X2 = X2, X3 = X3,
  U1_ = grid, U2_ = grid, newX3 = c(2, 5, 7),
  kernel = "Gaussian", h = 0.8)
arrayEst

}
\references{
Derumigny, A., & Fermanian, J. D. (2017).
About tests of the “simplifying” assumption for conditional copulas.
Dependence Modeling, 5(1), 154-197.
\doi{10.1515/demo-2017-0011}
}
\seealso{
\code{\link{estimateParCondCopula}} for estimating a conditional
copula in a parametric setting ( = where the conditional copula is assumed to
belong to a parametric class).
\code{\link{simpA.NP}} for a test that this conditional copula is
constant with respect to the value \eqn{x_3} of the conditioning variable.
}
