% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentroidWeberSetConcept.R
\name{centroidWeberSet}
\alias{centroidWeberSet}
\title{Compute centroid of Weber set}
\usage{
centroidWeberSet(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
Calculates the centroid of the Weber set for a game specified by a game vector.
}
\description{
Calculates the centroid of the Weber set for specified game.
}
\examples{
library(CoopGame)
v=c(0,0,0,2,2,3,5)
centroidWeberSet(v) 

}
\references{
Weber R.J. (1988) "Probabilistic values for games". In: Roth A.E. (Ed.), The Shapley Value. Essays in in honor of Lloyd S. Shapley, Cambridge University Press, pp. 101--119

Peters H. (2015)  \emph{Game Theory: A Multi-Leveled Approach}, 2nd Edition, Springer, pp. 327--329
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
