% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ImputationsetConcept.R
\name{imputationsetVertices}
\alias{imputationsetVertices}
\alias{imputationSetVertices}
\title{Compute vertices of imputation set}
\usage{
imputationsetVertices(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
rows of the matrix are the vertices of the imputation set
}
\description{
imputationsetVertices calculates the imputation set vertices 
for given game vector.
}
\examples{
library(CoopGame)
imputationsetVertices(c(0,0,0,1,1,1,2))

\donttest{
library(CoopGame)
v = c(2, 4, 5, 18, 24, 9, 24)

imputationsetVertices(v)

#      [,1] [,2] [,3]
#[1,]   15    4    5
#[2,]    2   17    5
#[3,]    2    4   18
}

}
\references{
Peleg B. and Sudhoelter P. (2007) \emph{Theory of cooperative games}, 2nd Edition, Springer, p. 20

Maschler M., Solan E. and Zamir S. (2013) \emph{Game Theory}, Cambridge University Press, p. 674

Osborne M.J. and Rubinstein A. (1994) \emph{A Course in Game Theory}, MIT Press, p. 278

Narahari Y. (2015)  \emph{Game Theory and Mechanism Design}, World Scientific Publishing, p. 407
}
\author{
Michael Maerz

Franz Mueller

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
