% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GamePropertyEssentiality.R
\name{isEssentialGame}
\alias{isEssentialGame}
\title{Check if game is essential}
\usage{
isEssentialGame(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
\code{TRUE} if the game is essential, else \code{FALSE}.
}
\description{
Checks if a TU game with n players is essential.
We call a game essential, if the value of the grand coalition   
is greater than the sum of the values of the singleton coalitions.
A game is essential, if \deqn{v(N) > \sum v({i})}. \cr
For an essential game the imputation set is nonempty and consists of more than one point.
}
\examples{
library(CoopGame)
isEssentialGame(c(1,2,3,4,4,4,7))

\donttest{
# Example of an essential game
library(CoopGame)
v1 <- c(0,0,0,60,60,60,72)
isEssentialGame(v1)

# Example of a game that is not essential  
library(CoopGame)
v2 <- c(30,30,15,60,60,60,72)
isEssentialGame(v2)

# Example of a game that is not essential 
library(CoopGame)
v3 <- c(20,20,32,60,60,60,72)
isEssentialGame(v3)
}

}
\references{
Chakravarty S.R., Mitra M. and Sarkar P. (2015) \emph{A Course on Cooperative Game Theory}, Cambridge University Press, p. 23

Gilles R. P. (2015)  \emph{The Cooperative Game Theory of Networks and Hierarchies}, Springer, p. 18
}
\author{
Michael Maerz

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
