% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ShapleyConcept.R
\name{shapleyValue}
\alias{shapleyValue}
\title{Compute Shapley value}
\usage{
shapleyValue(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
Shapley value for given game vector with n players
}
\description{
Calculates the Shapley value for n players with formula from Lloyd Shapley.
}
\examples{
library(CoopGame)
shapleyValue(v=c(0,0,0,1,2,3,7.5))

\donttest{
#Example of a non-superadditive game,
#i.e. the inheritance problem due to Ibn Ezra (1146),
#from paper by Robert Aumann from 2010 on
#'Some non-superadditive games, and their Shapley values, in the Talmud'
library(CoopGame)
Aumann2010Example<-c(120,60,40,30,120,120,120,60,60,40,120,120,120,60,120)
shapleyValue(Aumann2010Example)
#[1] 80.83333 20.83333 10.83333  7.50000
}

}
\references{
Shapley L.S. (1953) "A value for n-person games". In: Kuhn, H., Tucker, A.W. (Eds.), Contributions to the Theory of Games II, Princeton University Press, pp. 307--317

Aumann R.J. (2010) "Some non-superadditive games, and their Shapley values, in the Talmud", Int. Journal of Game Theory 39(1), pp. 3--10

Peters H. (2015)  \emph{Game Theory: A Multi-Leveled Approach}, 2nd Edition, Springer, pp. 156--159

Maschler M., Solan E. and Zamir S. (2013) \emph{Game Theory}, Cambridge University Press, pp. 748--781

Bertini C. (2011) "Shapley value", Encyclopedia of Power, SAGE Publications, p. 600--603
}
\author{
Alexandra Tiukkel

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
