% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cytopt_minmax.R
\name{cytopt_minmax_r}
\alias{cytopt_minmax_r}
\title{Function to estimate the type cell proportions in an unclassified cytometry data set denoted X_s
by using the classification Lab_source from an other cytometry data set X_s. With this function
an additional regularization parameter on the class proportions enables a faster computation of the
estimator.}
\usage{
cytopt_minmax_r(
  X_s,
  X_t,
  Lab_source,
  theta_true = NULL,
  eps = 1e-04,
  lbd = 1e-04,
  n_iter = 10000,
  step = 5,
  power = 0.99,
  monitoring = FALSE
)
}
\arguments{
\item{X_s}{Cytometry data set. The columns correspond to the different biological markers tracked.
One line corresponds to the cytometry measurements performed on one cell. The classification
of this Cytometry data set must be provided with the Lab_source parameters.}

\item{X_t}{Cytometry data set. The columns correspond to the different biological markers tracked.
One line corresponds to the cytometry measurements performed on one cell. The CytOpT algorithm
targets the cell type proportion in this Cytometry data set.}

\item{Lab_source}{Classification of the X_s Cytometry data set}

\item{theta_true}{If available, gold-standard proportions in the target data
set \code{X_t} derived from manual gating. It allows to assess the gap between
the estimate and the gold-standard. Default is \code{NULL}, in which case no
assessment is performed.}

\item{eps}{Regularization parameter of the Wasserstein distance}

\item{lbd}{an float constant that multiply the step-size policy. Default is \code{1e-04}.}

\item{n_iter}{an integer Constant that iterate method select. Default is \code{10000}.}

\item{step}{Constant that multiply the step-size policy. Default is \code{5}.}

\item{power}{the step size policy of the gradient ascent method is step/n^power.
Default is \code{0.99}.}

\item{monitoring}{boolean indicating whether Kullback-Leibler divergence should be
monitored and store throughout the optimization iterations. Default is \code{FALSE}.}
}
\value{
A list with the following elements:\code{Results_Minmax}
}
\description{
Function to estimate the type cell proportions in an unclassified cytometry data set denoted X_s
by using the classification Lab_source from an other cytometry data set X_s. With this function
an additional regularization parameter on the class proportions enables a faster computation of the
estimator.
}
