% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE_sim_update_state_cr.R
\name{DAISIE_sim_update_state_cr}
\alias{DAISIE_sim_update_state_cr}
\title{Updates state of island given sampled event for a constant rate case.}
\usage{
DAISIE_sim_update_state_cr(
  timeval,
  total_time,
  possible_event,
  maxspecID,
  mainland_spec,
  island_spec,
  stt_table
)
}
\arguments{
\item{timeval}{Numeric defining current time of simulation.}

\item{total_time}{Numeric defining the length of the simulation in time
units.}

\item{possible_event}{Numeric defining what event will happen.}

\item{maxspecID}{Current species IDs.}

\item{mainland_spec}{Number of mainland species.}

\item{island_spec}{Matrix with current state of simulation containing number
of species.}

\item{stt_table}{Matrix with number of species at each time step.}
}
\value{
The updated state of the system, which is a list with the
\code{island_spec} matrix, an integer \code{maxspecID} with the most recent
ID of species and the \code{stt_table}, a matrix with the current species
through time table.
}
\description{
Makes the event happen by updating island species matrix and species IDs.
What event happens is determined by the sampling in the algorithm.
}
\seealso{
\link{DAISIE_sim_core_cr},
\link{DAISIE_sim_update_state_cr}
}
\keyword{internal}
