% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE_rates.R
\name{get_immig_rate}
\alias{get_immig_rate}
\title{Calculate immigration rate}
\usage{
get_immig_rate(
  gam,
  A = 1,
  num_spec,
  K,
  mainland_n,
  trait_pars = NULL,
  island_spec = NULL
)
}
\arguments{
\item{gam}{A numeric with the per capita immigration rate.}

\item{A}{A numeric value for island area at a given point in time.}

\item{num_spec}{A numeric with the current number of species.}

\item{K}{A numeric with carrying capacity.}

\item{mainland_n}{A numeric stating the number of mainland species, that
is the number of species that can potentially colonize the island.
If using a clade-specific diversity dependence, this value is set to 1.
If using an island-wide diversity dependence, this value is set to the
number of mainland species.}

\item{trait_pars}{A named list containing diversification rates considering
  two trait states created by \code{\link{create_trait_pars}}:
\itemize{
  \item{[1]:A numeric with the per capita transition rate with state 1}
  \item{[2]:A numeric with the per capita immigration rate with state 2}
  \item{[3]:A numeric with the per capita extinction rate with state 2}
  \item{[4]:A numeric with the per capita anagenesis rate with state 2}
  \item{[5]:A numeric with the per capita cladogenesis rate with state 2}
  \item{[6]:A numeric with the per capita transition rate with state 2}
  \item{[7]:A numeric with the number of species with trait state 2 on
   mainland}
}}

\item{island_spec}{Matrix with current state of simulation containing number
of species.}
}
\description{
Internal function.
Calculates the immigration rate given the current number of
species in the system, the carrying capacity
}
\references{
Valente, Luis M., Rampal S. Etienne, and Albert B. Phillimore.
"The effects of island ontogeny on species diversity and phylogeny."
Proceedings of the Royal Society of London B: Biological Sciences 281.1784 (2014): 20133227.
}
\seealso{
Other rate calculations: 
\code{\link{DAISIE_plot_area}()},
\code{\link{get_ana_rate}()},
\code{\link{get_ext_rate}()},
\code{\link{island_area}()},
\code{\link{island_area_vector}()},
\code{\link{update_max_rates}()},
\code{\link{update_rates}()}
}
\author{
Pedro Neves, Joshua Lambert
}
\concept{rate calculations}
\keyword{internal}
